/*
 * Decompiled with CFR 0.152.
 */
package jmri.util.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;

public class RosterEntrySelection
implements Transferable,
ClipboardOwner {
    private final ArrayList<String> Ids;
    public static final DataFlavor rosterEntryFlavor = new DataFlavor(ArrayList.class, "RosterEntryIDs");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{rosterEntryFlavor};
    private static final List<DataFlavor> FLAVOR_LIST = Arrays.asList(FLAVORS);

    public RosterEntrySelection(ArrayList<String> rosterEntries) {
        this.Ids = rosterEntries;
    }

    public static RosterEntrySelection createRosterEntrySelection(ArrayList<RosterEntry> rosterEntries) {
        ArrayList<String> Ids = new ArrayList<String>(rosterEntries.size());
        rosterEntries.stream().forEach(re -> Ids.add(re.getId()));
        return new RosterEntrySelection(Ids);
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return Arrays.copyOf(FLAVORS, FLAVORS.length);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor df) {
        return FLAVOR_LIST.contains(df);
    }

    @Override
    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        if (df.equals(rosterEntryFlavor)) {
            return this.Ids;
        }
        throw new UnsupportedFlavorException(df);
    }

    @Override
    public void lostOwnership(Clipboard clpbrd, Transferable t) {
    }

    public static ArrayList<RosterEntry> getRosterEntries(Transferable t) throws UnsupportedFlavorException, IOException {
        if (t.isDataFlavorSupported(rosterEntryFlavor)) {
            ArrayList Ids = (ArrayList)t.getTransferData(rosterEntryFlavor);
            ArrayList<RosterEntry> REs = new ArrayList<RosterEntry>(Ids.size());
            for (String Id : Ids) {
                RosterEntry re = Roster.getDefault().entryFromTitle(Id);
                if (re == null) continue;
                REs.add(re);
            }
            return REs;
        }
        throw new UnsupportedFlavorException(t.getTransferDataFlavors()[0]);
    }
}

