/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jmri.util.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.swing.WindowInterface;

public class WindowMenu
extends JMenu
implements MenuListener {
    private Frame parentFrame;
    private List<JmriJFrame> framesList;

    public WindowMenu(WindowInterface wi) {
        super(Bundle.getMessage("MenuWindow"));
        this.parentFrame = wi.getFrame();
        this.addMenuListener(this);
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.framesList = JmriJFrame.getFrameList();
        this.removeAll();
        this.add(new AbstractAction(Bundle.getMessage("MenuItemMinimize")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WindowMenu.this.parentFrame != null) {
                    WindowMenu.this.parentFrame.setState(1);
                }
            }
        });
        this.add(new JSeparator());
        int framesNumber = this.framesList.size();
        int i = 0;
        while (i < framesNumber) {
            JmriJFrame iFrame = this.framesList.get(i);
            String windowName = iFrame.getTitle();
            if (windowName.equals("")) {
                windowName = "Untitled";
            }
            JCheckBoxMenuItem newItem = new JCheckBoxMenuItem(new AbstractAction(windowName){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int firstItem;
                    JMenuItem selectedItem = (JMenuItem)e.getSource();
                    int itemCount = WindowMenu.this.getItemCount();
                    int i = firstItem = itemCount - WindowMenu.this.framesList.size();
                    while (i < itemCount) {
                        if (selectedItem == WindowMenu.this.getItem(i) && (i -= firstItem) < WindowMenu.this.framesList.size()) {
                            ((JmriJFrame)WindowMenu.this.framesList.get(i)).setVisible(true);
                            ((JmriJFrame)WindowMenu.this.framesList.get(i)).setExtendedState(0);
                            return;
                        }
                        ++i;
                    }
                }
            });
            if (iFrame == this.parentFrame) {
                newItem.setState(true);
            }
            this.add(newItem);
            ++i;
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }
}

