/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Color;
import java.awt.Component;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jmri.util.Bundle;

final class ValidatingInputPane<T>
extends JPanel {
    private final Function<String, T> convertor;
    private final DocumentListener l = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            ValidatingInputPane.this.validateInput();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ValidatingInputPane.this.validateInput();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    };
    private Predicate<T> validator;
    private JComponent confirmUI;
    private String lastError;
    private IllegalArgumentException customException;
    private JTextArea errorMessage;
    private JTextField inputText;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea2;
    private JLabel promtptMessage;

    public ValidatingInputPane(Function<String, T> convertor) {
        this.initComponents();
        this.errorMessage.setVisible(false);
        this.convertor = convertor;
    }

    ValidatingInputPane<T> attachConfirmUI(JComponent confirm) {
        this.confirmUI = confirm;
        return this;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.inputText.getDocument().addDocumentListener(this.l);
        SwingUtilities.invokeLater(this::validateInput);
    }

    ValidatingInputPane<T> message(String msg) {
        this.promtptMessage.setText(msg);
        return this;
    }

    IllegalArgumentException getException() {
        return this.customException;
    }

    ValidatingInputPane<T> validator(Predicate<T> val) {
        this.validator = val;
        return this;
    }

    boolean hasError() {
        return this.lastError != null;
    }

    void setText(String text) {
        this.inputText.setText(text);
    }

    String getText() {
        return this.inputText.getText().trim();
    }

    T getValue() {
        String s = this.getText();
        return s.isEmpty() ? null : (T)this.convertor.apply(s);
    }

    String getErrorMessage() {
        return this.lastError;
    }

    private void validateInput() {
        if (this.isVisible()) {
            this.validateText(this.getText());
        }
    }

    private void clearErrors() {
        if (this.confirmUI != null) {
            this.confirmUI.setEnabled(true);
        }
        this.errorMessage.setText("");
        this.errorMessage.setVisible(false);
        this.customException = null;
        this.lastError = null;
    }

    void validateText(String text) {
        Component c;
        String msg;
        if (text.isEmpty()) {
            this.clearErrors();
            return;
        }
        try {
            T value = this.convertor.apply(text);
            if (this.validator == null || this.validator.test(value)) {
                this.clearErrors();
                return;
            }
            msg = Bundle.getMessage("InputDialogError");
        }
        catch (IllegalArgumentException ex) {
            msg = ex.getLocalizedMessage();
            this.customException = ex;
        }
        this.lastError = msg;
        this.errorMessage.setText(msg);
        this.errorMessage.setVisible(true);
        if (this.confirmUI != null) {
            this.confirmUI.setEnabled(false);
        }
        if ((c = SwingUtilities.getRoot(this)) != null) {
            c.invalidate();
            if (c instanceof JDialog) {
                ((JDialog)c).pack();
            }
        }
    }

    JTextField getTextField() {
        return this.inputText;
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.promtptMessage = new JLabel();
        this.inputText = new JTextField();
        this.errorMessage = new JTextArea();
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea2);
        this.promtptMessage.setText(" ");
        this.errorMessage.setEditable(false);
        this.errorMessage.setBackground(this.getBackground());
        this.errorMessage.setColumns(20);
        this.errorMessage.setForeground(Color.red);
        this.errorMessage.setRows(2);
        this.errorMessage.setToolTipText("");
        this.errorMessage.setAutoscrolls(false);
        this.errorMessage.setBorder(null);
        this.errorMessage.setFocusable(false);
        this.errorMessage.setRequestFocusEnabled(false);
        this.errorMessage.setVerifyInputWhenFocusTarget(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.promtptMessage, -1, -1, Short.MAX_VALUE).addComponent(this.errorMessage, -1, 253, Short.MAX_VALUE).addComponent(this.inputText)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.promtptMessage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputText, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorMessage, -2, 20, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

