/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Reportable;
import jmri.util.IntlUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeConversionUtil {
    private static final Logger log = LoggerFactory.getLogger(TypeConversionUtil.class);

    public static boolean isIntegerNumber(Object object) {
        return object instanceof AtomicInteger || object instanceof AtomicLong || object instanceof BigInteger || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long;
    }

    public static boolean isFloatingNumber(Object object) {
        return TypeConversionUtil.isIntegerNumber(object) || object instanceof BigDecimal || object instanceof Float || object instanceof Double;
    }

    public static boolean isString(Object object) {
        return object instanceof String;
    }

    private static boolean convertStringToBoolean(@Nonnull String str, boolean do_i18n) {
        try {
            double number = do_i18n ? IntlUtilities.doubleValue(str) : Double.parseDouble(str);
            return !(-0.5 < number) || !(number < 0.5);
        }
        catch (NumberFormatException | ParseException exception) {
            log.debug("The string '{}' cannot be parsed as a number", (Object)str);
            String patternString = "^0(\\.0+)?$";
            Pattern pattern = Pattern.compile(patternString, 2);
            Matcher matcher = pattern.matcher(str);
            if (matcher.matches()) {
                return false;
            }
            return !str.isEmpty();
        }
    }

    public static boolean convertToBoolean(@CheckForNull Object value, boolean do_i18n) {
        if (value == null) {
            return false;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return !map.isEmpty();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return !collection.isEmpty();
        }
        if (value instanceof Reportable) {
            value = ((Reportable)value).toReportString();
        }
        if (value instanceof Number) {
            double number = ((Number)value).doubleValue();
            return !(-0.5 < number) || !(number < 0.5);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null) {
            return false;
        }
        return TypeConversionUtil.convertStringToBoolean(value.toString(), do_i18n);
    }

    private static long convertStringToLong(@Nonnull String str) {
        String patternString = "(\\-?\\d+)";
        Pattern pattern = Pattern.compile(patternString, 2);
        Matcher matcher = pattern.matcher(str);
        if (matcher.lookingAt()) {
            String theNumber = matcher.group(1);
            long number = Long.parseLong(theNumber);
            log.debug("the string {} is converted to the number {}", (Object)str, (Object)number);
            return number;
        }
        log.warn("the string \"{}\" cannot be converted to a number", (Object)str);
        return 0L;
    }

    public static long convertToLong(@CheckForNull Object value) {
        if (value == null) {
            log.warn("the object is null and the returned number is therefore 0.0");
            return 0L;
        }
        if (value instanceof Reportable) {
            value = ((Reportable)value).toReportString();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value == null) {
            return 0L;
        }
        return TypeConversionUtil.convertStringToLong(value.toString());
    }

    private static double convertStringToDouble(@Nonnull String str, boolean do_i18n) {
        String patternString = "(\\-?\\d+(\\.\\d+)?(e\\-?\\d+)?)";
        Pattern pattern = Pattern.compile(patternString, 2);
        Matcher matcher = pattern.matcher(str);
        if (matcher.lookingAt()) {
            String theNumber = matcher.group(1);
            double number = Double.parseDouble(theNumber);
            log.debug("the string {} is converted to the number {}", (Object)str, (Object)number);
            return number;
        }
        log.warn("the string \"{}\" cannot be converted to a number", (Object)str);
        return 0.0;
    }

    public static double convertToDouble(@CheckForNull Object value, boolean do_i18n) {
        if (value == null) {
            log.warn("the object is null and the returned number is therefore 0.0");
            return 0.0;
        }
        if (value instanceof Reportable) {
            value = ((Reportable)value).toReportString();
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value == null) {
            return 0.0;
        }
        if (do_i18n) {
            try {
                double number = IntlUtilities.doubleValue(value.toString());
                return number;
            }
            catch (ParseException parseException) {
                log.debug("The string '{}' cannot be parsed as a number", value);
            }
        }
        return TypeConversionUtil.convertStringToDouble(value.toString(), do_i18n);
    }

    @Nonnull
    public static String convertToString(@CheckForNull Object value, boolean do_i18n) {
        if (value == null) {
            return "";
        }
        if (value instanceof Reportable) {
            return ((Reportable)value).toReportString();
        }
        if (value instanceof Number && do_i18n) {
            return IntlUtilities.valueOf(((Number)value).doubleValue());
        }
        return value.toString();
    }
}

