/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import jmri.util.ThreadingUtil;

@Immutable
public final class TimerUtil {
    static final Timer commonTimer = new Timer("JMRI Common Timer", true);

    public static void schedule(@Nonnull TimerTask task, @Nonnull Date time) {
        commonTimer.schedule(task, time);
    }

    public static void schedule(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        commonTimer.schedule(task, firstTime, period);
    }

    public static void schedule(@Nonnull TimerTask task, long delay) {
        commonTimer.schedule(task, delay);
    }

    public static void schedule(@Nonnull TimerTask task, long delay, long period) {
        commonTimer.schedule(task, delay, period);
    }

    public static void scheduleAtFixedRate(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        commonTimer.schedule(task, firstTime, period);
    }

    public static void scheduleAtFixedRate(@Nonnull TimerTask task, long delay, long period) {
        commonTimer.schedule(task, delay, period);
    }

    private static TimerTask gtask(final TimerTask task) {
        return new TimerTask(){

            @Override
            public void run() {
                ThreadingUtil.runOnGUIEventually(() -> task.run());
            }
        };
    }

    public static void scheduleOnGUIThread(@Nonnull TimerTask task, @Nonnull Date time) {
        commonTimer.schedule(TimerUtil.gtask(task), time);
    }

    public static void scheduleOnGUIThread(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        commonTimer.schedule(TimerUtil.gtask(task), firstTime, period);
    }

    public static void scheduleOnGUIThread(@Nonnull TimerTask task, long delay) {
        commonTimer.schedule(TimerUtil.gtask(task), delay);
    }

    public static void scheduleOnGUIThread(@Nonnull TimerTask task, long delay, long period) {
        commonTimer.schedule(TimerUtil.gtask(task), delay, period);
    }

    public static void scheduleAtFixedRateOnGUIThread(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        commonTimer.schedule(TimerUtil.gtask(task), firstTime, period);
    }

    public static void scheduleAtFixedRateOnGUIThread(@Nonnull TimerTask task, long delay, long period) {
        commonTimer.schedule(TimerUtil.gtask(task), delay, period);
    }

    private static TimerTask ltask(final TimerTask task) {
        return new TimerTask(){

            @Override
            public void run() {
                ThreadingUtil.runOnLayoutEventually(() -> task.run());
            }
        };
    }

    public static void scheduleOnLayoutThread(@Nonnull TimerTask task, @Nonnull Date time) {
        commonTimer.schedule(TimerUtil.ltask(task), time);
    }

    public static void scheduleOnLayoutThread(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        commonTimer.schedule(TimerUtil.ltask(task), firstTime, period);
    }

    public static void scheduleOnLayoutThread(@Nonnull TimerTask task, long delay) {
        commonTimer.schedule(TimerUtil.ltask(task), delay);
    }

    public static void scheduleOnLayoutThread(@Nonnull TimerTask task, long delay, long period) {
        commonTimer.schedule(TimerUtil.ltask(task), delay, period);
    }

    public static void scheduleAtFixedRateOnLayoutThread(@Nonnull TimerTask task, @Nonnull Date firstTime, long period) {
        commonTimer.schedule(TimerUtil.ltask(task), firstTime, period);
    }

    public static void scheduleAtFixedRateOnLayoutThread(@Nonnull TimerTask task, long delay, long period) {
        commonTimer.schedule(TimerUtil.ltask(task), delay, period);
    }
}

