/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    public static final String HTML_CLOSE_TAG = "</html>";
    public static final String HTML_OPEN_TAG = "<html>";
    public static final String LINEBREAK = "\n";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);

    @CheckReturnValue
    public static int getStateFromName(String name, int[] states, String[] names) {
        int i = 0;
        while (i < states.length) {
            if (name.equals(names[i])) {
                return states[i];
            }
            ++i;
        }
        return -1;
    }

    @CheckReturnValue
    public static String[] getNamesFromStateMasked(int state, int[] states, int[] masks, String[] names) {
        int count = 0;
        String[] temp = new String[states.length];
        int i = 0;
        while (i < states.length) {
            if (((state ^ states[i]) & masks[i]) == 0) {
                temp[count++] = names[i];
            }
            ++i;
        }
        String[] output = new String[count];
        System.arraycopy(temp, 0, output, 0, count);
        return output;
    }

    @CheckReturnValue
    @CheckForNull
    public static String getNameFromState(int state, @Nonnull int[] states, @Nonnull String[] names) {
        int i = 0;
        while (i < states.length) {
            if (state == states[i]) {
                return names[i];
            }
            ++i;
        }
        return null;
    }

    @CheckReturnValue
    @Nonnull
    public static String twoHexFromInt(int val) {
        StringBuilder sb = new StringBuilder();
        sb.append(HEX_CHARS[(val & 0xF0) >> 4]);
        sb.append(HEX_CHARS[val & 0xF]);
        return sb.toString();
    }

    @CheckReturnValue
    @Nonnull
    public static String appendTwoHexFromInt(int val, @Nonnull String inString) {
        StringBuilder sb = new StringBuilder(inString);
        sb.append(StringUtil.twoHexFromInt(val));
        return sb.toString();
    }

    @CheckReturnValue
    @Nonnull
    public static String to8Bits(int val, boolean msbLeft) {
        String result = "";
        int i = 0;
        while (i < 8) {
            result = msbLeft ? String.valueOf((val & 1) != 0 ? "1" : "0") + result : String.valueOf(result) + ((val & 1) != 0 ? "1" : "0");
            val >>= 1;
            ++i;
        }
        return result;
    }

    @CheckReturnValue
    @Nonnull
    public static String hexStringFromBytes(@Nonnull byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte aByte = byArray[n2];
            sb.append(HEX_CHARS[(aByte & 0xF0) >> 4]);
            sb.append(HEX_CHARS[aByte & 0xF]);
            sb.append(' ');
            ++n2;
        }
        return sb.toString();
    }

    @CheckReturnValue
    @Nonnull
    public static String hexStringFromInts(@Nonnull int[] v) {
        StringBuilder retval = new StringBuilder();
        int[] nArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            retval.append(StringUtil.twoHexFromInt(e));
            retval.append(" ");
            ++n2;
        }
        return retval.toString();
    }

    @CheckReturnValue
    @Nonnull
    public static byte[] bytesFromHexString(@Nonnull String s) {
        String ts = String.valueOf(s) + "  ";
        int len = 0;
        int i = 0;
        while (i < s.length()) {
            if (ts.charAt(i) != ' ') {
                if (ts.charAt(i + 1) != ' ') {
                    ++i;
                    ++len;
                } else {
                    ++len;
                }
            }
            ++i;
        }
        byte[] b = new byte[len];
        int saveAt = 0;
        int i2 = 0;
        while (i2 < s.length()) {
            if (ts.charAt(i2) != ' ') {
                String v;
                if (ts.charAt(i2 + 1) != ' ') {
                    v = "" + ts.charAt(i2) + ts.charAt(i2 + 1);
                    b[saveAt] = (byte)Integer.valueOf(v, 16).intValue();
                    ++i2;
                    ++saveAt;
                } else {
                    v = "" + ts.charAt(i2);
                    b[saveAt] = (byte)Integer.valueOf(v, 16).intValue();
                    ++saveAt;
                }
            }
            ++i2;
        }
        return b;
    }

    @Nonnull
    public static int[] intBytesWithTotalFromNonSpacedHexString(@Nonnull String s, boolean headerTotal) {
        if (s.length() % 2 == 0) {
            int numBytes = s.length() / 2;
            if (headerTotal) {
                int[] arr = new int[numBytes + 1];
                arr[0] = numBytes;
                int i = 0;
                while (i < numBytes) {
                    arr[i + 1] = StringUtil.getByte(i, s);
                    ++i;
                }
                return arr;
            }
            int[] arr = new int[numBytes];
            int i = 0;
            while (i < numBytes) {
                arr[i] = StringUtil.getByte(i, s);
                ++i;
            }
            return arr;
        }
        return new int[1];
    }

    public static int getHexDigit(int index, @Nonnull String byteString) {
        int b = 0;
        b = byteString.charAt(index);
        b = b >= 48 && b <= 57 ? (b -= 48) : (b >= 65 && b <= 70 ? b - 65 + 10 : (b >= 97 && b <= 102 ? b - 97 + 10 : 0));
        return (byte)b;
    }

    public static int getByte(int b, @Nonnull String byteString) {
        if (b >= 0) {
            int index = b * 2;
            int hi = StringUtil.getHexDigit(index++, byteString);
            int lo = StringUtil.getHexDigit(index, byteString);
            if (hi < 16 && lo < 16) {
                return hi * 16 + lo;
            }
        }
        return 0;
    }

    @CheckReturnValue
    @Nonnull
    public static byte[] fullTextToHexArray(@Nonnull String s, int numBytes) {
        byte[] b = new byte[numBytes];
        Arrays.fill(b, (byte)32);
        s = s.substring(0, Math.min(s.length(), numBytes));
        String convrtedNoSpaces = String.format("%x", new BigInteger(1, s.getBytes()));
        int byteNum = 0;
        int i = 0;
        while (i < convrtedNoSpaces.length()) {
            b[byteNum] = (byte)Integer.parseInt(convrtedNoSpaces.substring(i, i + 2), 16);
            ++byteNum;
            i += 2;
        }
        return b;
    }

    public static void sortUpperCase(@Nonnull Object[] values) {
        Arrays.sort(values, (o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString()));
    }

    public static void numberSort(@Nonnull String[] values) throws NumberFormatException {
        int i = 0;
        while (i <= values.length - 2) {
            int j = values.length - 2;
            while (j >= i) {
                if (Integer.parseInt(values[j]) > Integer.parseInt(values[j + 1])) {
                    String temp = values[j];
                    values[j] = values[j + 1];
                    values[j + 1] = temp;
                }
                --j;
            }
            ++i;
        }
    }

    @CheckReturnValue
    @CheckForNull
    public static String parenQuote(@CheckForNull String in) {
        if (in == null || in.equals("")) {
            return in;
        }
        StringBuilder result = new StringBuilder();
        int level = 0;
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            switch (c) {
                case '(': {
                    ++level;
                    break;
                }
                case '\\': {
                    result.append('\\');
                    break;
                }
                case ')': {
                    if (--level >= 0) break;
                    level = 0;
                    result.append('\\');
                    break;
                }
            }
            result.append(c);
            ++i;
        }
        return new String(result);
    }

    @CheckReturnValue
    @CheckForNull
    static String parenUnQuote(@CheckForNull String in) {
        if (in == null || in.equals("")) {
            return in;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            if (c == '\\' && (c = in.charAt(++i)) != '\\' && c != ')') {
                c = (char)(c + 92);
            }
            result.append(c);
            ++i;
        }
        return new String(result);
    }

    @CheckReturnValue
    @Nonnull
    public static List<String> splitParens(@CheckForNull String in) {
        ArrayList<String> result = new ArrayList<String>();
        if (in == null || in.equals("")) {
            return result;
        }
        int level = 0;
        String temp = "";
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            switch (c) {
                case '(': {
                    ++level;
                    break;
                }
                case '\\': {
                    temp = String.valueOf(temp) + c;
                    c = in.charAt(++i);
                    break;
                }
                case ')': {
                    --level;
                    break;
                }
            }
            temp = String.valueOf(temp) + c;
            if (level == 0) {
                result.add(temp);
                temp = "";
            }
            ++i;
        }
        return result;
    }

    @CheckReturnValue
    @Nonnull
    public static <E> String arrayToString(@Nonnull E[] v) {
        StringBuilder retval = new StringBuilder();
        boolean first = true;
        E[] EArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            if (!first) {
                retval.append(',');
            }
            first = false;
            retval.append('[');
            retval.append(e.toString());
            retval.append(']');
            ++n2;
        }
        return new String(retval);
    }

    @CheckReturnValue
    @Nonnull
    public static String arrayToString(@Nonnull byte[] v) {
        StringBuilder retval = new StringBuilder();
        boolean first = true;
        byte[] byArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            byte e = byArray[n2];
            if (!first) {
                retval.append(',');
            }
            first = false;
            retval.append('[');
            retval.append(e);
            retval.append(']');
            ++n2;
        }
        return new String(retval);
    }

    @CheckReturnValue
    @Nonnull
    public static String arrayToString(@Nonnull int[] v) {
        StringBuilder retval = new StringBuilder();
        boolean first = true;
        int[] nArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            if (!first) {
                retval.append(',');
            }
            first = false;
            retval.append('[');
            retval.append(e);
            retval.append(']');
            ++n2;
        }
        return new String(retval);
    }

    @CheckReturnValue
    public static String padString(String value, int length) {
        if (length > 1) {
            return String.format("%-" + length + "s", value.substring(0, Math.min(value.length(), length - 1)));
        }
        return value;
    }

    @CheckReturnValue
    public static int getFirstIntFromString(@Nonnull String str) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c != ' ') {
                if (Character.isDigit(c)) {
                    sb.append(c);
                } else if (sb.length() > 0) {
                    break;
                }
            } else if (sb.length() > 0) break;
            ++i;
        }
        if (sb.length() > 0) {
            return Integer.parseInt(sb.toString());
        }
        return -1;
    }

    @CheckReturnValue
    public static int getLastIntFromString(@Nonnull String str) {
        StringBuilder sb = new StringBuilder();
        int i = str.length() - 1;
        while (i >= 0) {
            char c = str.charAt(i);
            if (c != ' ') {
                if (Character.isDigit(c)) {
                    sb.insert(0, c);
                } else if (sb.length() > 0) {
                    break;
                }
            } else if (sb.length() > 0) break;
            --i;
        }
        if (sb.length() > 0) {
            return Integer.parseInt(sb.toString());
        }
        return -1;
    }

    @CheckForNull
    public static String incrementLastNumberInString(@Nonnull String str, int increment) {
        int num = StringUtil.getLastIntFromString(str);
        return num == -1 ? null : StringUtil.replaceLast(str, String.valueOf(num), String.valueOf(num + increment));
    }

    @CheckReturnValue
    @Nonnull
    public static String replaceLast(@Nonnull String string, @Nonnull String from, @Nonnull String to) {
        int lastIndex = string.lastIndexOf(from);
        if (lastIndex < 0) {
            return string;
        }
        String tail = string.substring(lastIndex).replaceFirst(from, to);
        return String.valueOf(string.substring(0, lastIndex)) + tail;
    }

    public static String concatTextHtmlAware(String baseText, String extraText) {
        if (baseText == null && extraText == null) {
            return null;
        }
        if (baseText == null) {
            return extraText;
        }
        if (extraText == null) {
            return baseText;
        }
        boolean hasHtml = false;
        String result = String.valueOf(baseText) + extraText;
        result = result.replaceAll("(?i)<html>", "");
        if (!(result = result.replaceAll("(?i)</html>", "")).equals(String.valueOf(baseText) + extraText)) {
            hasHtml = true;
            log.debug("\n\nbaseText:\n\"{}\"\nextraText:\n\"{}\"\n", (Object)baseText, (Object)extraText);
        }
        if (hasHtml) {
            result = HTML_OPEN_TAG + result + HTML_CLOSE_TAG;
            log.debug("\nCombined String:\n\"{}\"\n", (Object)result);
        }
        return result;
    }
}

