/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import jmri.NamedBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PropertyChangeEventQueue {
    final Collection<NamedBean> items = new ArrayList<NamedBean>();
    static final int MAX_SIZE = 100;
    final BlockingQueue<PropertyChangeEvent> dq = new ArrayBlockingQueue<PropertyChangeEvent>(100);
    final PropertyChangeListener listener = e -> {
        log.trace(" handling event {}", (Object)e);
        boolean success = this.dq.offer(e);
        if (!success) {
            log.error("Could not process event {} from {} in {}", new Object[]{e.getPropertyName(), e.getSource(), this.dq});
        }
    };
    private static final Logger log = LoggerFactory.getLogger(PropertyChangeEventQueue.class);

    public PropertyChangeEventQueue(@Nonnull Collection<NamedBean> collection) {
        this();
        for (NamedBean item : collection) {
            this.items.add(item);
            item.addPropertyChangeListener(this.listener);
        }
        if (log.isTraceEnabled()) {
            log.trace("Created {}", (Object)this.toString());
        }
    }

    public PropertyChangeEventQueue(@Nonnull NamedBean[] array) {
        this(Arrays.asList(array));
    }

    private PropertyChangeEventQueue() {
    }

    public void dispose() {
        log.trace("dispose() {}", this.items);
        this.items.forEach(bean -> bean.removePropertyChangeListener(this.listener));
    }

    public PropertyChangeEvent take() throws InterruptedException {
        return this.dq.take();
    }

    public PropertyChangeEvent poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.dq.poll(timeout, unit);
    }

    public String toString() {
        StringBuffer b = new StringBuffer("PropertyChangeEventQueue for");
        this.items.stream().forEachOrdered(bean -> {
            b.append(" (\"");
            b.append(bean.getDisplayName());
            b.append("\")");
        });
        return new String(b);
    }
}

