/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import jmri.NamedBean;
import jmri.util.PhysicalLocationPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalLocation
extends Vector3f {
    private boolean _isTunnel;
    public static final PhysicalLocation Origin = new PhysicalLocation(0.0f, 0.0f, 0.0f);
    public static final String NBPropertyKey = "physical_location";
    private static final Logger log = LoggerFactory.getLogger(PhysicalLocation.class);

    public static PhysicalLocation translate(PhysicalLocation loc, PhysicalLocation ref) {
        if (loc == null || ref == null) {
            return loc;
        }
        PhysicalLocation rv = new PhysicalLocation();
        rv.setX(loc.getX() - ref.getX());
        rv.setY(loc.getY() - ref.getY());
        rv.setZ(loc.getZ() - ref.getZ());
        return rv;
    }

    public static PhysicalLocation getBeanPhysicalLocation(NamedBean b) {
        String s = (String)b.getProperty(NBPropertyKey);
        if (s == null || s.isEmpty()) {
            return Origin;
        }
        return PhysicalLocation.parse(s);
    }

    public static void setBeanPhysicalLocation(PhysicalLocation p, NamedBean b) {
        b.setProperty(NBPropertyKey, p.toString());
    }

    public static PhysicalLocationPanel getPanel(String title) {
        return new PhysicalLocationPanel(title);
    }

    public static PhysicalLocation parse(String pos) {
        Matcher m;
        String syntax;
        block7: {
            syntax = "\\((\\s*[-+]?[0-9]*\\.?[0-9]+), (\\s*[-+]?[0-9]*\\.?[0-9]+), (\\s*[-+]?[0-9]*\\.?[0-9]+)\\)\\(?([tunnel]*)\\)?";
            Pattern p = Pattern.compile(syntax);
            m = p.matcher(pos);
            if (m.matches()) break block7;
            log.error("String does not match a valid position pattern. syntax= {} string = {}", (Object)syntax, (Object)pos);
            return null;
        }
        try {
            String xs = m.group(1);
            String ys = m.group(2);
            String zs = m.group(3);
            log.debug("Loading position: x = {} y = {} z = {}", new Object[]{xs, ys, zs});
            boolean is_tunnel = false;
            int i = 4;
            while (i < m.groupCount() + 1) {
                if (m.group(i) != null && "tunnel".equals(m.group(i))) {
                    is_tunnel = true;
                }
                ++i;
            }
            return new PhysicalLocation(Float.parseFloat(xs), Float.parseFloat(ys), Float.parseFloat(zs), is_tunnel);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            log.error("Malformed listener position syntax! {}", (Object)syntax);
            return null;
        }
        catch (IllegalStateException e) {
            log.error("Group called before match operation executed syntax={} string= {} {}", new Object[]{syntax, pos, e.toString()});
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            log.error("Index out of bounds {} string= {} {}", new Object[]{syntax, pos, e.toString()});
            return null;
        }
    }

    public String toString() {
        String s = "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
        if (this._isTunnel) {
            s = String.valueOf(s) + "(tunnel)";
        }
        return s;
    }

    public Vector3d toVector3d() {
        return new Vector3d((Vector3f)this);
    }

    public PhysicalLocation() {
        this._isTunnel = false;
    }

    public PhysicalLocation(Vector3f v) {
        super(v);
        this._isTunnel = false;
    }

    public PhysicalLocation(Vector3d v) {
        super(v);
        this._isTunnel = false;
    }

    public PhysicalLocation(float x, float y, float z, boolean isTunnel) {
        super(x, y, z);
        this._isTunnel = isTunnel;
    }

    public PhysicalLocation(float x, float y, float z) {
        this(x, y, z, false);
    }

    public PhysicalLocation(double x, double y, double z) {
        this(x, y, z, false);
    }

    public PhysicalLocation(double x, double y, double z, boolean isTunnel) {
        this((float)x, (float)y, (float)z, isTunnel);
    }

    public PhysicalLocation(PhysicalLocation p) {
        this(p.getX(), p.getY(), p.getZ(), p.isTunnel());
    }

    public boolean isTunnel() {
        return this._isTunnel;
    }

    public void setIsTunnel(boolean t) {
        this._isTunnel = t;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return ((Object)((Object)this)).getClass().equals(o.getClass()) && this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this._isTunnel ? 1 : 0) + super.hashCode();
        return hash;
    }

    public void translate(PhysicalLocation ref) {
        if (ref == null) {
            return;
        }
        this.setX(this.getX() - ref.getX());
        this.setY(this.getY() - ref.getY());
        this.setZ(this.getZ() - ref.getZ());
    }
}

