/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class NoArchiveFileFilter
extends FileFilter {
    private final String description;
    private final Set<String> extensions = new HashSet<String>();

    public NoArchiveFileFilter() {
        this("Omit archive files");
    }

    public NoArchiveFileFilter(String description) {
        this.description = description;
    }

    public NoArchiveFileFilter(String description, String ... extensions) {
        this(description);
        Arrays.stream(extensions).filter(e -> e != null).forEach(e -> {
            boolean bl = this.extensions.add((String)e);
        });
    }

    @Override
    public boolean accept(File f) {
        String extension = FilenameUtils.getExtension((String)f.getName());
        if ("zip".equalsIgnoreCase(extension) || "jar".equalsIgnoreCase(extension)) {
            return false;
        }
        return this.extensions.isEmpty() || this.extensions.contains(extension);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

