/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import jmri.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartMessage {
    private final String boundary;
    private static final String LINE_FEED = "\r\n";
    private final HttpURLConnection httpConn;
    private final String charSet;
    private final OutputStream outStream;
    private final PrintWriter writer;
    private static final Logger log = LoggerFactory.getLogger(MultipartMessage.class);

    public MultipartMessage(String requestURL, String charSet) throws IOException {
        this.charSet = charSet;
        this.boundary = "===" + System.currentTimeMillis() + "===";
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.httpConn.setRequestProperty("User-Agent", "JMRI " + Version.getCanonicalVersion());
        this.outStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outStream, this.charSet), true);
    }

    public void addFormField(String name, String value) {
        log.debug("add form field: {}; value: {}", (Object)name, (Object)value);
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain; charset=" + this.charSet).append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(value).append(LINE_FEED);
        this.writer.flush();
    }

    public void addFilePart(String fieldName, File uploadFile) throws IOException {
        this.addFilePart(fieldName, uploadFile, URLConnection.guessContentTypeFromName(uploadFile.getName()));
    }

    public void addFilePart(String fieldName, File uploadFile, String fileType) throws IOException {
        log.debug("add file field: {}; file: {}; type: {}", new Object[]{fieldName, uploadFile, fileType});
        String fileName = uploadFile.getName();
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: " + fileType).append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileInputStream inStream = new FileInputStream(uploadFile);){
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = inStream.read(buffer)) != -1) {
                this.outStream.write(buffer, 0, bytesRead);
            }
            this.outStream.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    public void addHeaderField(String name, String value) {
        log.debug("add header field: {}; value: {}", (Object)name, (Object)value);
        this.writer.append(String.valueOf(name) + ": " + value).append(LINE_FEED);
        this.writer.flush();
    }

    public List<String> finish() throws IOException {
        ArrayList<String> response;
        block11: {
            response = new ArrayList<String>();
            this.writer.append(LINE_FEED).flush();
            this.writer.append("--" + this.boundary + "--").append(LINE_FEED);
            this.writer.close();
            int status = this.httpConn.getResponseCode();
            if (status == 200) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        response.add(line);
                    }
                    break block11;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            throw new IOException("Server returned non-OK status: " + status);
        }
        this.httpConn.disconnect();
        return response;
    }
}

