/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import jmri.util.FileUtil;
import jmri.util.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JmriLocalEntityResolver
implements EntityResolver {
    private static final Logger log = LoggerFactory.getLogger(JmriLocalEntityResolver.class);

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        block28: {
            String source;
            block29: {
                String path;
                String scheme;
                block27: {
                    block26: {
                        block25: {
                            log.trace("-- got entity request {}", (Object)systemId);
                            try {
                                URI uri = new URI(systemId);
                                log.trace("systemId: {}", (Object)systemId);
                                scheme = uri.getScheme();
                                source = uri.getSchemeSpecificPart();
                                path = uri.getPath();
                                log.trace("scheme: {}", (Object)scheme);
                                log.trace("source: {}", (Object)source);
                                log.trace("path: {}", (Object)path);
                                if (!scheme.equals("http")) break block25;
                                if (systemId.equals("http://www.w3.org/2001/XInclude.xsd")) {
                                    path = "/xml/schema/xinclude.xsd";
                                }
                                String filename = path.substring(1).trim();
                                log.trace("http finds filename: {}", (Object)filename);
                                InputStream stream = FileUtil.findInputStream(filename);
                                if (stream != null) {
                                    return new InputSource(stream);
                                }
                                log.debug("did not find local type 3 DTD file: {}", (Object)filename);
                                return null;
                            }
                            catch (URISyntaxException e1) {
                                log.warn(e1.getLocalizedMessage(), (Throwable)e1);
                                return null;
                            }
                        }
                        if (path == null || !path.startsWith("../DTD")) break block26;
                        String filename = "xml" + File.separator + "DTD" + File.separator + path;
                        log.trace("starts with ../DTD finds filename: {}", (Object)filename);
                        InputStream stream = FileUtil.findInputStream(filename);
                        if (stream != null) {
                            return new InputSource(stream);
                        }
                        log.error("did not find type 1 DTD file: {}", (Object)filename);
                        return null;
                    }
                    if (path == null || path.contains("/")) break block27;
                    String filename = "xml" + File.separator + "DTD" + File.separator + path;
                    log.trace("doesn't contain / finds filename: {}", (Object)filename);
                    InputStream stream = FileUtil.findInputStream(filename);
                    if (stream != null) {
                        return new InputSource(stream);
                    }
                    log.error("did not find type 2 entity file: {}", (Object)filename);
                    return null;
                }
                if (!scheme.equals("file")) break block28;
                if (path == null) break block29;
                log.trace("scheme file finds path: {}", (Object)path);
                InputStream stream = FileUtil.findInputStream(path);
                if (stream != null) {
                    log.trace("file exists, used");
                    return new InputSource(stream);
                }
                String realSeparator = File.separator;
                if (SystemType.isWindows()) {
                    int forIndex = path.indexOf("/");
                    int backIndex = path.indexOf("\\");
                    if (forIndex >= 0 && backIndex < 0) {
                        realSeparator = "/";
                    } else if (forIndex < 0 && backIndex >= 0) {
                        realSeparator = "\\";
                    } else if (forIndex > 0 && backIndex >= forIndex) {
                        realSeparator = "\\";
                    } else if (backIndex > 0 && forIndex >= backIndex) {
                        realSeparator = "/";
                    }
                    log.trace(" forIndex {} backIndex {}", (Object)forIndex, (Object)backIndex);
                }
                log.trace("File.separator {} realSeparator {}", (Object)File.separator, (Object)realSeparator);
                if (path.lastIndexOf(String.valueOf(realSeparator) + "DTD" + realSeparator) >= 0) {
                    String modifiedPath;
                    log.trace("file not exist, DTD in name, insert xml directory");
                    path = modifiedPath = String.valueOf(realSeparator) + "xml" + path.substring(path.lastIndexOf(String.valueOf(realSeparator) + "DTD" + realSeparator), path.length()).trim();
                } else {
                    String modifiedPath;
                    log.trace("file not exist, no DTD, insert xml/DTD directory");
                    path = modifiedPath = String.valueOf(realSeparator) + "xml" + realSeparator + "DTD" + path.substring(path.lastIndexOf(realSeparator), path.length());
                }
                stream = FileUtil.findInputStream(path);
                log.trace("attempting : {}", (Object)path);
                if (stream != null) {
                    return new InputSource(stream);
                }
                log.error("did not find direct entity path: {}", (Object)path);
                return null;
            }
            log.trace("schema file with null path");
            try {
                return new InputSource(new FileReader(new File(source)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.error("did not find direct entity file: {}", (Object)source);
                return null;
            }
        }
        log.error("could not parse systemId: {}", (Object)systemId);
        return null;
    }
}

