/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import jmri.InstanceManager;
import jmri.ModifiedFlag;
import jmri.ShutDownManager;
import jmri.UserPreferencesManager;
import jmri.beans.BeanInterface;
import jmri.beans.BeanUtil;
import jmri.implementation.AbstractShutDownTask;
import jmri.util.Bundle;
import jmri.util.HelpUtil;
import jmri.util.SystemType;
import jmri.util.WindowMenu;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriJFrame
extends JFrame
implements WindowListener,
ModifiedFlag,
ComponentListener,
WindowInterface,
BeanInterface {
    protected boolean allowInFrameServlet = true;
    private static final ArrayList<ScreenDimensions> screenDim = JmriJFrame.getInitialScreenDimensionsOnce();
    private final Dimension maxSizeDimension = this.getMaximumSize();
    String windowFrameRef;
    private static String escapeKeyAction = "escapeKeyAction";
    private boolean escapeKeyActionClosesWindow = false;
    private boolean modifiedFlag = false;
    static final String WINDOW_MODIFIED = "windowModified";
    private transient AbstractShutDownTask task = null;
    protected boolean reuseFrameSavedPosition = true;
    protected boolean reuseFrameSavedSized = true;
    protected HashMap<String, Object> properties = new HashMap();
    protected transient WindowInterface windowInterface = null;
    private static final Logger log = LoggerFactory.getLogger(JmriJFrame.class);

    public JmriJFrame(boolean saveSize, boolean savePosition) {
        this.reuseFrameSavedPosition = savePosition;
        this.reuseFrameSavedSized = saveSize;
        this.initFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initFrame() {
        JmriJFrameManager m;
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.windowInterface = new JmriJFrameInterface();
        JmriJFrameManager jmriJFrameManager = m = JmriJFrame.getJmriJFrameManager();
        synchronized (jmriJFrameManager) {
            for (JmriJFrame j : m) {
                if (j.getExtendedState() == 1 || !j.isVisible() || j.getX() != this.getX() || j.getY() != this.getY()) continue;
                this.offSetFrameOnScreen(j);
            }
            m.add(this);
        }
        this.setIconImage(this.getToolkit().getImage("resources/jmri32x32.gif"));
        this.setDefaultCloseOperation(2);
        this.addWindowCloseShortCut();
        this.windowFrameRef = this.getClass().getName();
        if (!this.getClass().getName().equals(JmriJFrame.class.getName())) {
            this.generateWindowRef();
            this.setFrameLocation();
        }
    }

    public JmriJFrame() {
        this(true, true);
    }

    public JmriJFrame(String name) {
        this(name, true, true);
    }

    public JmriJFrame(String name, boolean saveSize, boolean savePosition) {
        this(saveSize, savePosition);
        this.setFrameTitle(name);
    }

    final void setFrameTitle(String name) {
        this.setTitle(name);
        this.generateWindowRef();
        if (this.getClass().getName().equals(JmriJFrame.class.getName()) && (this.getTitle() == null || this.getTitle().isEmpty())) {
            return;
        }
        this.setFrameLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePrivateWindow() {
        JmriJFrameManager m;
        JmriJFrameManager jmriJFrameManager = m = JmriJFrame.getJmriJFrameManager();
        synchronized (jmriJFrameManager) {
            m.remove(this);
        }
    }

    public void setFrameLocation() {
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> {
            if (prefsMgr.hasProperties(this.windowFrameRef)) {
                Rectangle window = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                boolean isVisible = false;
                log.debug("Initial window location & size: {}", (Object)window);
                log.debug("Detected {} screens.", (Object)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length);
                log.debug(this.windowFrameRef);
                if (this.reuseFrameSavedPosition) {
                    log.debug("setFrameLocation 1st clause sets \"{}\" location to {}", (Object)this.getTitle(), (Object)prefsMgr.getWindowLocation(this.windowFrameRef));
                    window.setLocation(prefsMgr.getWindowLocation(this.windowFrameRef));
                }
                if (this.reuseFrameSavedSized && prefsMgr.getWindowSize(this.windowFrameRef).getWidth() != 0.0 && prefsMgr.getWindowSize(this.windowFrameRef).getHeight() != 0.0) {
                    log.debug("setFrameLocation 2nd clause sets \"{}\" preferredSize to {}", (Object)this.getTitle(), (Object)prefsMgr.getWindowSize(this.windowFrameRef));
                    this.setPreferredSize(prefsMgr.getWindowSize(this.windowFrameRef));
                    log.debug("setFrameLocation 2nd clause sets \"{}\" size to {}", (Object)this.getTitle(), (Object)prefsMgr.getWindowSize(this.windowFrameRef));
                    window.setSize(prefsMgr.getWindowSize(this.windowFrameRef));
                    log.debug("window now set to location: {}", (Object)window);
                }
                for (JmriJFrame j : JmriJFrame.getJmriJFrameManager()) {
                    if (!j.getClass().getName().equals(this.getClass().getName()) || j.getExtendedState() == 1 || !j.isVisible() || !j.getTitle().equals(this.getTitle()) || j.getX() != this.getX() || j.getY() != this.getY()) continue;
                    log.debug("setFrameLocation 3rd clause calls offSetFrameOnScreen({})", (Object)j);
                    this.offSetFrameOnScreen(j);
                }
                for (ScreenDimensions sd : JmriJFrame.getScreenDimensions()) {
                    boolean canShow = window.intersects(sd.getBounds());
                    if (canShow) {
                        isVisible = true;
                    }
                    log.debug("Screen {} bounds {}, {}", new Object[]{sd.getGraphicsDevice().getIDstring(), sd.getBounds(), sd.getInsets()});
                    log.debug("Does \"{}\" window {} fit on screen {}? {}", new Object[]{this.getTitle(), window, sd.getGraphicsDevice().getIDstring(), canShow});
                }
                log.debug("Can \"{}\" window {} display on a screen? {}", new Object[]{this.getTitle(), window, isVisible});
                if (isVisible) {
                    this.setLocation(window.getLocation());
                    this.setSize(window.getSize());
                    log.debug("Set \"{}\" location to {} and size to {}", new Object[]{this.getTitle(), window.getLocation(), window.getSize()});
                }
            }
        });
    }

    public static ArrayList<ScreenDimensions> getScreenDimensions() {
        return screenDim;
    }

    private static ArrayList<ScreenDimensions> getInitialScreenDimensionsOnce() {
        ArrayList<ScreenDimensions> screenDimensions = new ArrayList<ScreenDimensions>();
        if (GraphicsEnvironment.isHeadless()) {
            return screenDimensions;
        }
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice gd = graphicsDeviceArray[n2];
            Rectangle bounds = new Rectangle();
            Insets insets = new Insets(0, 0, 0, 0);
            GraphicsConfiguration[] graphicsConfigurationArray = gd.getConfigurations();
            int n3 = graphicsConfigurationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                GraphicsConfiguration gc = graphicsConfigurationArray[n4];
                bounds = bounds.isEmpty() ? gc.getBounds() : bounds.union(gc.getBounds());
                insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
                ++n4;
            }
            screenDimensions.add(new ScreenDimensions(bounds, insets, gd));
            ++n2;
        }
        return screenDimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateWindowRef() {
        JmriJFrameManager m;
        String initref = this.getClass().getName();
        if (this.getTitle() != null && !this.getTitle().equals("")) {
            initref = initref.equals(JmriJFrame.class.getName()) ? this.getTitle() : String.valueOf(initref) + ":" + this.getTitle();
        }
        int refNo = 1;
        String ref = initref;
        JmriJFrameManager jmriJFrameManager = m = JmriJFrame.getJmriJFrameManager();
        synchronized (jmriJFrameManager) {
            for (JmriJFrame j : m) {
                if (j == this || j.getWindowFrameRef() == null || !j.getWindowFrameRef().equals(ref)) continue;
                ref = String.valueOf(initref) + ":" + refNo;
                ++refNo;
            }
        }
        log.debug("Created windowFrameRef: {}", (Object)ref);
        this.windowFrameRef = ref;
    }

    @Override
    public void pack() {
        if (this.getPreferredSize().width < 100 || this.getPreferredSize().height < 100) {
            this.setPreferredSize(null);
        }
        super.pack();
        this.reSizeToFitOnScreen();
    }

    public void undecorate() {
        boolean visible = this.isVisible();
        this.setVisible(false);
        super.dispose();
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        this.pack();
        this.setVisible(visible);
    }

    void reSizeToFitOnScreen() {
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        log.trace("reSizeToFitOnScreen of \"{}\" starts with maximum size {}", (Object)this.getTitle(), (Object)this.maxSizeDimension);
        log.trace("reSizeToFitOnScreen starts with preferred height {} width {}", (Object)height, (Object)width);
        log.trace("reSizeToFitOnScreen starts with location {},{}", (Object)this.getX(), (Object)this.getY());
        ScreenDimensions sd = this.getContainingDisplay(this.getLocation());
        Point locationOnDisplay = new Point(this.getLocation().x - sd.getBounds().x, this.getLocation().y - sd.getBounds().y);
        log.trace("reSizeToFitScreen normalises origin to {}, {}", (Object)locationOnDisplay.x, (Object)locationOnDisplay.y);
        if ((double)(width + locationOnDisplay.x) >= this.maxSizeDimension.getWidth()) {
            int offsetX = width + locationOnDisplay.x - (int)this.maxSizeDimension.getWidth();
            log.trace("reSizeToFitScreen moves \"{}\" left {} pixels", (Object)this.getTitle(), (Object)offsetX);
            int positionX = locationOnDisplay.x - offsetX;
            if (positionX < 0) {
                log.trace("reSizeToFitScreen sets \"{}\" X to zero", (Object)this.getTitle());
                positionX = 0;
            }
            this.setLocation(positionX + sd.getBounds().x, this.getY());
            log.trace("reSizeToFitOnScreen during X calculation sets location {}, {}", (Object)(positionX + sd.getBounds().x), (Object)this.getY());
            if ((double)(width + locationOnDisplay.x) >= this.maxSizeDimension.getWidth()) {
                width -= (int)((double)(width + locationOnDisplay.x) - this.maxSizeDimension.getWidth());
                log.trace("reSizeToFitScreen sets \"{}\" width to {}", (Object)this.getTitle(), (Object)width);
            }
        }
        if ((double)(height + locationOnDisplay.y) >= this.maxSizeDimension.getHeight()) {
            int offsetY = height + locationOnDisplay.y - (int)this.maxSizeDimension.getHeight();
            log.trace("reSizeToFitScreen moves \"{}\" up {} pixels", (Object)this.getTitle(), (Object)offsetY);
            int positionY = locationOnDisplay.y - offsetY;
            if (positionY < 0) {
                log.trace("reSizeToFitScreen sets \"{}\" Y to zero", (Object)this.getTitle());
                positionY = 0;
            }
            this.setLocation(this.getX(), positionY + sd.getBounds().y);
            log.trace("reSizeToFitOnScreen during Y calculation sets location {}, {}", (Object)this.getX(), (Object)(positionY + sd.getBounds().y));
            if ((double)(height + this.getY()) >= this.maxSizeDimension.getHeight()) {
                height -= (int)((double)(height + locationOnDisplay.y) - this.maxSizeDimension.getHeight());
                log.trace("reSizeToFitScreen sets \"{}\" height to {}", (Object)this.getTitle(), (Object)height);
            }
        }
        this.setSize(width, height);
        log.debug("reSizeToFitOnScreen sets height {} width {}", (Object)height, (Object)width);
    }

    void offSetFrameOnScreen(JmriJFrame f) {
        int frameOffSetx = this.getX() + f.getInsets().top;
        int frameOffSety = this.getY() + f.getInsets().top;
        Dimension dim = this.getMaximumSize();
        if ((double)frameOffSetx >= dim.getWidth() * 0.75) {
            frameOffSety = 0;
            frameOffSetx = f.getInsets().top * 2;
        }
        if ((double)frameOffSety >= dim.getHeight() * 0.75) {
            frameOffSety = 0;
            frameOffSetx = f.getInsets().top * 2;
        }
        if ((double)frameOffSetx >= dim.getWidth()) {
            frameOffSetx = f.getInsets().top / 2;
        }
        this.setLocation(frameOffSetx, frameOffSety);
    }

    public String getWindowFrameRef() {
        return this.windowFrameRef;
    }

    public void initComponents() {
    }

    public final void addHelpMenu(String ref, boolean direct) {
        JMenuBar bar = this.getJMenuBar();
        if (bar == null) {
            bar = new JMenuBar();
        }
        bar.add(new WindowMenu(this));
        HelpUtil.helpMenu(bar, ref, direct);
        this.setJMenuBar(bar);
    }

    void addWindowCloseShortCut() {
        AbstractAction act = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JmriJFrame.this.processWindowEvent(new WindowEvent(JmriJFrame.this, 201));
            }
        };
        this.getRootPane().getActionMap().put("close", act);
        int stdMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap im = this.getRootPane().getInputMap(1);
        String modifier = KeyStroke.getKeyStroke(87, stdMask).toString();
        String keyCode = String.valueOf(modifier.substring(0, modifier.length() - 1)) + Bundle.getMessage("VkKeyWindowClose").substring(0, 1);
        im.put(KeyStroke.getKeyStroke(keyCode), "close");
    }

    public void setEscapeKeyAction(AbstractAction action) {
        JRootPane root = this.getRootPane();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.escapeKeyActionClosesWindow = false;
        if (action != null) {
            root.getInputMap(2).put(escape, escapeKeyAction);
            root.getActionMap().put(escapeKeyAction, action);
        } else {
            root.getInputMap(2).remove(escape);
            root.getActionMap().remove(escapeKeyAction);
        }
    }

    public AbstractAction getEscapeKeyAction() {
        return (AbstractAction)this.getRootPane().getActionMap().get(escapeKeyAction);
    }

    public void setEscapeKeyClosesWindow(boolean closesWindow) {
        if (closesWindow) {
            this.setEscapeKeyAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JmriJFrame.this.processWindowEvent(new WindowEvent(JmriJFrame.this, 201));
                }
            });
        } else {
            this.setEscapeKeyAction(null);
        }
        this.escapeKeyActionClosesWindow = closesWindow;
    }

    public boolean getEscapeKeyClosesWindow() {
        return this.escapeKeyActionClosesWindow && this.getEscapeKeyAction() != null;
    }

    private ScreenDimensions getContainingDisplay(Point location) {
        for (ScreenDimensions sd : JmriJFrame.getScreenDimensions()) {
            boolean isOnThisScreen = sd.getBounds().contains(location);
            log.debug("Is \"{}\" window origin {} located on screen {}? {}", new Object[]{this.getTitle(), this.getLocation(), sd.getGraphicsDevice().getIDstring(), isOnThisScreen});
            if (!isOnThisScreen) continue;
            return sd;
        }
        log.debug("Falling back to using the primary display");
        return JmriJFrame.getScreenDimensions().get(0);
    }

    @Override
    public Dimension getMaximumSize() {
        if (GraphicsEnvironment.isHeadless()) {
            return new Dimension(0, 0);
        }
        try {
            try {
                String sh;
                String sw;
                ScreenDimensions sd = this.getContainingDisplay(this.getLocation());
                int widthInset = sd.getInsets().right + sd.getInsets().left;
                int heightInset = sd.getInsets().top + sd.getInsets().bottom;
                if (widthInset == 0 && heightInset == 0) {
                    String osName = SystemType.getOSName();
                    if (SystemType.isLinux()) {
                        heightInset = 70;
                    } else if (osName.equals("Windows XP") || osName.equals("Windows 98") || osName.equals("Windows 2000")) {
                        heightInset = 28;
                    }
                }
                if ((sw = System.getProperty("jmri.inset.width")) != null) {
                    try {
                        widthInset = Integer.parseInt(sw);
                    }
                    catch (NumberFormatException e1) {
                        log.error("Error parsing jmri.inset.width: {}", (Object)e1.getMessage());
                    }
                }
                if ((sh = System.getProperty("jmri.inset.height")) != null) {
                    try {
                        heightInset = Integer.parseInt(sh);
                    }
                    catch (NumberFormatException e1) {
                        log.error("Error parsing jmri.inset.height: {}", (Object)e1.getMessage());
                    }
                }
                log.trace("getMaximumSize returns normally {},{}", (Object)(sd.getBounds().width - widthInset), (Object)(sd.getBounds().height - heightInset));
                return new Dimension(sd.getBounds().width - widthInset, sd.getBounds().height - heightInset);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Dimension screen = this.getToolkit().getScreenSize();
                log.trace("getMaximumSize returns approx due to failure {},{}", (Object)screen.width, (Object)screen.height);
                return new Dimension(screen.width, screen.height - 45);
            }
        }
        catch (RuntimeException runtimeException) {
            log.trace("getMaximumSize returns super due to failure {}", (Object)super.getMaximumSize());
            return super.getMaximumSize();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension screen = this.getMaximumSize();
        int width = Math.min(super.getPreferredSize().width, screen.width);
        int height = Math.min(super.getPreferredSize().height, screen.height);
        log.debug("getPreferredSize \"{}\" returns width {} height {}", new Object[]{this.getTitle(), width, height});
        return new Dimension(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static List<JmriJFrame> getFrameList() {
        JmriJFrameManager m;
        JmriJFrameManager jmriJFrameManager = m = JmriJFrame.getJmriJFrameManager();
        synchronized (jmriJFrameManager) {
            return new ArrayList<JmriJFrame>(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends JmriJFrame> List<T> getFrameList(@Nonnull Class<T> type) {
        JmriJFrameManager m;
        ArrayList result = new ArrayList();
        JmriJFrameManager jmriJFrameManager = m = JmriJFrame.getJmriJFrameManager();
        synchronized (jmriJFrameManager) {
            m.stream().filter(f -> type.isInstance(f)).forEachOrdered(f -> result.add(f));
        }
        return result;
    }

    public static JmriJFrame getFrame(String name) {
        for (JmriJFrame j : JmriJFrame.getFrameList()) {
            if (!j.getTitle().equals(name)) continue;
            return j;
        }
        return null;
    }

    public void setSavePosition(boolean save) {
        this.reuseFrameSavedPosition = save;
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> prefsMgr.setSaveWindowLocation(this.windowFrameRef, save));
    }

    public void setSaveSize(boolean save) {
        this.reuseFrameSavedSized = save;
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> prefsMgr.setSaveWindowSize(this.windowFrameRef, save));
    }

    public boolean getSavePosition() {
        return this.reuseFrameSavedPosition;
    }

    public boolean getSaveSize() {
        return this.reuseFrameSavedSized;
    }

    @Override
    public void setModifiedFlag(boolean flag) {
        this.modifiedFlag = flag;
        this.markWindowModified(this.modifiedFlag);
    }

    @Override
    public boolean getModifiedFlag() {
        return this.modifiedFlag;
    }

    protected void handleModified() {
        if (this.getModifiedFlag()) {
            this.setVisible(true);
            int result = JOptionPane.showOptionDialog(this, Bundle.getMessage("WarnChangedMsg"), Bundle.getMessage("WarnChangedTitle"), 0, 2, null, new String[]{Bundle.getMessage("WarnYesSave"), Bundle.getMessage("WarnNoClose")}, Bundle.getMessage("WarnYesSave"));
            if (result == 0) {
                this.storeValues();
            }
        }
    }

    protected void storeValues() {
        log.error("default storeValues does nothing for \"{}\"", (Object)this.getTitle());
    }

    public void markWindowModified(boolean yes) {
        this.getRootPane().putClientProperty(WINDOW_MODIFIED, yes ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.handleModified();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(p -> {
            if (this.reuseFrameSavedPosition && this.isVisible()) {
                p.setWindowLocation(this.windowFrameRef, this.getLocation());
            }
        });
    }

    @Override
    public void componentResized(ComponentEvent e) {
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(p -> {
            if (this.reuseFrameSavedSized && this.isVisible()) {
                this.saveWindowSize((UserPreferencesManager)p);
            }
        });
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    protected void setShutDownTask() {
        this.task = new AbstractShutDownTask(this.getTitle()){

            @Override
            public Boolean call() {
                JmriJFrame.this.handleModified();
                return Boolean.TRUE;
            }

            @Override
            public void run() {
            }
        };
        InstanceManager.getDefault(ShutDownManager.class).register(this.task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OverridingMethodsMustInvokeSuper
    public void dispose() {
        JmriJFrameManager m;
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(p -> {
            if (this.reuseFrameSavedPosition) {
                p.setWindowLocation(this.windowFrameRef, this.getLocation());
            }
            if (this.reuseFrameSavedSized) {
                this.saveWindowSize((UserPreferencesManager)p);
            }
        });
        log.debug("dispose \"{}\"", (Object)this.getTitle());
        if (this.windowInterface != null) {
            this.windowInterface.dispose();
        }
        if (this.task != null) {
            InstanceManager.getDefault(ShutDownManager.class).deregister(this.task);
            this.task = null;
        }
        JmriJFrameManager jmriJFrameManager = m = JmriJFrame.getJmriJFrameManager();
        synchronized (jmriJFrameManager) {
            m.remove(this);
        }
        super.dispose();
    }

    private void saveWindowSize(UserPreferencesManager p) {
        p.setWindowSize(this.windowFrameRef, super.getSize());
    }

    @Override
    public void setIndexedProperty(String key, int index, Object value) {
        if (BeanUtil.hasIntrospectedProperty(this, key)) {
            BeanUtil.setIntrospectedIndexedProperty(this, key, index, value);
        } else {
            if (!this.properties.containsKey(key)) {
                this.properties.put(key, new Object[0]);
            }
            ((Object[])this.properties.get((Object)key))[index] = value;
        }
    }

    @Override
    public Object getIndexedProperty(String key, int index) {
        if (this.properties.containsKey(key) && this.properties.get(key).getClass().isArray()) {
            return ((Object[])this.properties.get(key))[index];
        }
        return BeanUtil.getIntrospectedIndexedProperty(this, key, index);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (BeanUtil.hasIntrospectedProperty(this, key)) {
            BeanUtil.setIntrospectedProperty(this, key, value);
        } else {
            this.properties.put(key, value);
        }
    }

    @Override
    public Object getProperty(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        return BeanUtil.getIntrospectedProperty(this, key);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key) || BeanUtil.hasIntrospectedProperty(this, key);
    }

    @Override
    public boolean hasIndexedProperty(String key) {
        return this.properties.containsKey(key) && this.properties.get(key).getClass().isArray() || BeanUtil.hasIntrospectedIndexedProperty(this, key);
    }

    @Override
    public void show(JmriPanel child, JmriAbstractAction action) {
        if (this.windowInterface != null) {
            this.windowInterface.show(child, action);
        }
    }

    @Override
    public void show(JmriPanel child, JmriAbstractAction action, WindowInterface.Hint hint) {
        if (this.windowInterface != null) {
            this.windowInterface.show(child, action, hint);
        }
    }

    @Override
    public boolean multipleInstances() {
        if (this.windowInterface != null) {
            return this.windowInterface.multipleInstances();
        }
        return false;
    }

    public void setWindowInterface(WindowInterface wi) {
        this.windowInterface = wi;
    }

    public WindowInterface getWindowInterface() {
        return this.windowInterface;
    }

    @Override
    public Set<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.properties.keySet());
        names.addAll(BeanUtil.getIntrospectedPropertyNames(this));
        return names;
    }

    public void setAllowInFrameServlet(boolean allow) {
        this.allowInFrameServlet = allow;
    }

    public boolean getAllowInFrameServlet() {
        return this.allowInFrameServlet;
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    private static JmriJFrameManager getJmriJFrameManager() {
        return InstanceManager.getOptionalDefault(JmriJFrameManager.class).orElseGet(() -> InstanceManager.setDefault(JmriJFrameManager.class, new JmriJFrameManager()));
    }

    private static class JmriJFrameManager
    extends ArrayList<JmriJFrame> {
        private JmriJFrameManager() {
        }
    }

    public static class ScreenDimensions {
        final Rectangle bounds;
        final Insets insets;
        final GraphicsDevice gd;

        public ScreenDimensions(Rectangle bounds, Insets insets, GraphicsDevice gd) {
            this.bounds = bounds;
            this.insets = insets;
            this.gd = gd;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public GraphicsDevice getGraphicsDevice() {
            return this.gd;
        }
    }
}

