/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import jmri.util.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriInsets {
    private static final String DESKTOP_ENVIRONMENTS = "kdesktop|gnome-panel|xfce|darwin|icewm";
    private static final String GNOME_CONFIG = "%gconf.xml";
    private static final String GNOME_PANEL = "_panel_screen";
    private static final String GNOME_ROOT = String.valueOf(System.getProperty("user.home")) + "/.gconf/apps/panel/toplevels/";
    private static final String KDE_CONFIG = String.valueOf(System.getProperty("user.home")) + "/.kde/share/config/kickerrc";
    private static final String OS_NAME = SystemType.getOSName();
    private static int linuxWM = -2;
    private static final Logger log = LoggerFactory.getLogger(JmriInsets.class);

    public static Insets getInsets() {
        if (linuxWM == -2) {
            linuxWM = JmriInsets.getLinuxWindowManager();
        }
        switch (linuxWM) {
            case 0: {
                return JmriInsets.getKDEInsets();
            }
            case 1: {
                return JmriInsets.getGnomeInsets();
            }
            case 2: {
                return JmriInsets.getXfceInsets();
            }
            case 3: {
                return JmriInsets.getDarwinInsets();
            }
            case 4: {
                return JmriInsets.getIcewmInsets();
            }
        }
        return JmriInsets.getDefaultInsets();
    }

    /*
     * Exception decompiling
     */
    private static int getLinuxWindowManager() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Insets getKDEInsets() {
        int[] nArray = new int[5];
        nArray[0] = 24;
        nArray[1] = 30;
        nArray[2] = 46;
        nArray[3] = 58;
        int[] sizes = nArray;
        int[] i = new int[5];
        int iniCustomSize = JmriInsets.getKdeINI("General", "CustomSize");
        int iniSize = JmriInsets.getKdeINI("General", "Size");
        int iniPosition = JmriInsets.getKdeINI("General", "Position");
        int position = iniPosition == -1 ? 3 : iniPosition;
        int size = iniCustomSize == -1 || iniSize != 4 ? iniSize : iniCustomSize;
        i[position] = size = size < 24 ? sizes[size] : size;
        return new Insets(i[2], i[0], i[3], i[1]);
    }

    private static Insets getGnomeInsets() {
        File gnomeRoot = new File(GNOME_ROOT);
        int n = 0;
        int s = 0;
        int e = 0;
        int w = 0;
        File[] files = gnomeRoot.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n2 = files.length;
            int n3 = 0;
            while (n3 < n2) {
                int val;
                File f = fileArray[n3];
                String folder = f.getName();
                if (f.isDirectory() && folder.contains(GNOME_PANEL) && (val = JmriInsets.getGnomeXML(new File(String.valueOf(GNOME_ROOT) + "/" + folder + "/" + GNOME_CONFIG))) != -1) {
                    if (folder.startsWith("top_panel_screen")) {
                        n = Math.max(val, n);
                    } else if (folder.startsWith("bottom_panel_screen")) {
                        s = Math.max(val, s);
                    } else if (folder.startsWith("right_panel_screen")) {
                        e = Math.max(val, e);
                    } else if (folder.startsWith("left_panel_screen")) {
                        w = Math.max(val, w);
                    }
                }
                ++n3;
            }
        }
        return new Insets(n, w, s, e);
    }

    private static Insets getXfceInsets() {
        return JmriInsets.getDefaultInsets(false);
    }

    private static Insets getDarwinInsets() {
        return JmriInsets.getDefaultInsets(false);
    }

    private static Insets getIcewmInsets() {
        return new Insets(0, 0, 25, 0);
    }

    private static Insets getDefaultInsets() {
        if (!OS_NAME.toLowerCase().startsWith("windows") && !OS_NAME.toLowerCase().startsWith("mac")) {
            return JmriInsets.getDefaultInsets(false);
        }
        return JmriInsets.getDefaultInsets(true);
    }

    private static Insets getDefaultInsets(boolean logOS) {
        if (logOS) {
            log.trace("Trying default insets for {}", (Object)OS_NAME);
        }
        try {
            GraphicsDevice[] gs;
            GraphicsDevice[] graphicsDeviceArray = gs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int n = gs.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsConfiguration[] gc;
                GraphicsDevice g = graphicsDeviceArray[n2];
                GraphicsConfiguration[] graphicsConfigurationArray = gc = g.getConfigurations();
                if (gc.length != 0) {
                    GraphicsConfiguration element = graphicsConfigurationArray[0];
                    return Toolkit.getDefaultToolkit().getScreenInsets(element);
                }
                ++n2;
            }
        }
        catch (HeadlessException headlessException) {
            log.debug("Warning: Headless error - no GUI available");
        }
        return new Insets(0, 0, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getGnomeXML(File xmlFile) {
        try {
            String temp;
            boolean found;
            block18: {
                found = false;
                Throwable throwable = null;
                Object var4_5 = null;
                try {
                    FileReader reader = new FileReader(xmlFile);
                    try {
                        try (BufferedReader buffer = new BufferedReader(reader);){
                            temp = buffer.readLine();
                            while (temp != null) {
                                if (temp.contains("<entry name=\"size\"")) {
                                    found = true;
                                    break;
                                }
                                temp = buffer.readLine();
                            }
                        }
                        if (reader == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (reader == null) throw throwable;
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            if (temp == null) {
                return -1;
            }
            if (!found) return -1;
            temp = temp.substring(temp.indexOf("value=\"") + 7);
            return Integer.parseInt(temp.substring(0, temp.indexOf(34)));
        }
        catch (IOException e) {
            log.error("Error parsing Gnome XML: {}", (Object)e.getMessage());
        }
        return -1;
    }

    /*
     * Exception decompiling
     */
    private static int getKdeINI(String category, String component) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 22[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

