/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

@Deprecated
public class JTextPaneAppender
extends AppenderSkeleton {
    JTextPane myTextPane;
    Hashtable<String, MutableAttributeSet> myAttributeSet;

    public JTextPaneAppender(Layout aLayout, String aName, Filter[] aFilterArray, JTextPane aTextPane) {
        this();
        this.layout = aLayout;
        this.name = aName;
        this.myTextPane = aTextPane;
        if (aFilterArray != null) {
            Filter[] filterArray = aFilterArray;
            int n = aFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Filter aFilterArray1 = filterArray[n2];
                if (aFilterArray1 != null) {
                    this.addFilter(aFilterArray1);
                }
                ++n2;
            }
        }
        this.createAttributes();
    }

    public JTextPaneAppender() {
        this.createAttributes();
    }

    public void close() {
    }

    private void createAttributes() {
        String[] prio = new String[]{Level.FATAL.toString(), Level.ERROR.toString(), Level.WARN.toString(), Level.INFO.toString(), Level.DEBUG.toString(), Level.TRACE.toString()};
        this.myAttributeSet = new Hashtable();
        int i = 0;
        while (i < prio.length) {
            SimpleAttributeSet att = new SimpleAttributeSet();
            this.myAttributeSet.put(prio[i], att);
            StyleConstants.setFontSize(att, 14);
            ++i;
        }
        StyleConstants.setForeground(this.myAttributeSet.get(Level.FATAL.toString()), Color.red);
        StyleConstants.setForeground(this.myAttributeSet.get(Level.ERROR.toString()), Color.red);
        StyleConstants.setForeground(this.myAttributeSet.get(Level.WARN.toString()), Color.orange);
        StyleConstants.setForeground(this.myAttributeSet.get(Level.INFO.toString()), Color.black);
        StyleConstants.setForeground(this.myAttributeSet.get(Level.DEBUG.toString()), Color.black);
        StyleConstants.setForeground(this.myAttributeSet.get(Level.TRACE.toString()), Color.black);
    }

    public void append(LoggingEvent event) {
        if (this.myTextPane == null) {
            LogLog.warn((String)"TextPane is not initialized");
            return;
        }
        String temp = this.layout.format(event);
        String[] stackTrace = event.getThrowableStrRep();
        if (stackTrace != null) {
            StringBuffer sb = new StringBuffer(temp);
            int i = 0;
            while (i < stackTrace.length) {
                sb.append("    ").append(stackTrace[i]).append("\n");
                ++i;
            }
            temp = sb.toString();
        }
        String text = temp;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.logIt(text, event);
            } else {
                SwingUtilities.invokeAndWait(() -> this.logIt(text, event));
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("JTextPaneAppender interrupted while doing logging on GUI thread");
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            System.err.println("JTextPaneAppender error while logging on GUI thread: " + e.getCause());
        }
    }

    private void logIt(String text, LoggingEvent event) {
        try {
            StyledDocument myDoc = this.myTextPane.getStyledDocument();
            myDoc.insertString(myDoc.getLength(), text, this.myAttributeSet.get(event.getLevel().toString()));
            this.myTextPane.setCaretPosition(myDoc.getLength());
        }
        catch (BadLocationException badex) {
            System.err.println(badex);
        }
    }

    public JTextPane getTextPane() {
        return this.myTextPane;
    }

    public void setTextPane(JTextPane aTextpane) {
        this.myTextPane = aTextpane;
    }

    private void setColor(Level p, Color v) {
        StyleConstants.setForeground(this.myAttributeSet.get(p.toString()), v);
    }

    private Color getColor(Level p) {
        Color c = StyleConstants.getForeground(this.myAttributeSet.get(p.toString()));
        return c == null ? null : c;
    }

    public void setColorEmerg(Color color) {
        this.setColor(Level.FATAL, color);
    }

    public Color getColorEmerg() {
        return this.getColor(Level.FATAL);
    }

    public void setColorError(Color color) {
        this.setColor(Level.ERROR, color);
    }

    public Color getColorError() {
        return this.getColor(Level.ERROR);
    }

    public void setColorWarn(Color color) {
        this.setColor(Level.WARN, color);
    }

    public Color getColorWarn() {
        return this.getColor(Level.WARN);
    }

    public void setColorInfo(Color color) {
        this.setColor(Level.INFO, color);
    }

    public Color getColorInfo() {
        return this.getColor(Level.INFO);
    }

    public void setColorDebug(Color color) {
        this.setColor(Level.DEBUG, color);
    }

    public Color getColorDebug() {
        return this.getColor(Level.DEBUG);
    }

    public void setFontSize(int aSize) {
        Enumeration<MutableAttributeSet> e = this.myAttributeSet.elements();
        while (e.hasMoreElements()) {
            StyleConstants.setFontSize(e.nextElement(), aSize);
        }
    }

    public void setFontSize(int aSize, Level aLevel) {
        MutableAttributeSet set = this.myAttributeSet.get(aLevel.toString());
        if (set != null) {
            StyleConstants.setFontSize(set, aSize);
        }
    }

    public int getFontSize(Level aLevel) {
        AttributeSet attrSet = this.myAttributeSet.get(aLevel.toString());
        if (attrSet == null) {
            throw new IllegalArgumentException("Unhandled Level: " + aLevel.toString());
        }
        return StyleConstants.getFontSize(attrSet);
    }

    public void setFontName(String aName) {
        Enumeration<MutableAttributeSet> e = this.myAttributeSet.elements();
        while (e.hasMoreElements()) {
            StyleConstants.setFontFamily(e.nextElement(), aName);
        }
    }

    public void setFontName(String aName, Level aLevel) {
        MutableAttributeSet set = this.myAttributeSet.get(aLevel.toString());
        if (set != null) {
            StyleConstants.setFontFamily(set, aName);
        }
    }

    public String getFontName(Level aLevel) {
        AttributeSet attrSet = this.myAttributeSet.get(aLevel.toString());
        if (attrSet == null) {
            throw new IllegalArgumentException("Unhandled Level: " + aLevel.toString());
        }
        return StyleConstants.getFontFamily(attrSet);
    }

    public boolean requiresLayout() {
        return true;
    }
}

