/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmri.InstanceManager;
import jmri.swing.PreferencesPanel;
import jmri.util.Bundle;
import jmri.util.HelpUtilPreferences;

public class HelpUtilPreferencesPanel
extends JPanel
implements PreferencesPanel {
    private final HelpUtilPreferences _preferences = InstanceManager.getDefault(HelpUtilPreferences.class);
    JRadioButton _openHelpOnFileRadioButton;
    JRadioButton _openHelpOnlineRadioButton;
    JRadioButton _openHelpOnJMRIWebServerRadioButton;
    ButtonGroup _openHelpButtonGroup;

    public HelpUtilPreferencesPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.getHelpPanel());
    }

    private boolean setValues() {
        boolean didSet = true;
        this._preferences.setOpenHelpOnFile(this._openHelpOnFileRadioButton.isSelected());
        this._preferences.setOpenHelpOnline(this._openHelpOnlineRadioButton.isSelected());
        this._preferences.setOpenHelpOnJMRIWebServer(this._openHelpOnJMRIWebServerRadioButton.isSelected());
        return didSet;
    }

    private JPanel getHelpPanel() {
        JPanel panel = new JPanel();
        this._openHelpButtonGroup = new ButtonGroup();
        this._openHelpOnFileRadioButton = new JRadioButton(Bundle.getMessage("Help_LabelOpenHelpOnFile"));
        this._openHelpOnFileRadioButton.setToolTipText(Bundle.getMessage("Help_ToolTipLabelOpenHelpOnFile"));
        this._openHelpButtonGroup.add(this._openHelpOnFileRadioButton);
        this._openHelpOnlineRadioButton = new JRadioButton(Bundle.getMessage("Help_LabelOpenHelpOnline"));
        this._openHelpOnlineRadioButton.setToolTipText(Bundle.getMessage("Help_ToolTipLabelOpenHelpOnline"));
        this._openHelpButtonGroup.add(this._openHelpOnlineRadioButton);
        this._openHelpOnJMRIWebServerRadioButton = new JRadioButton(Bundle.getMessage("Help_LabelOpenHelpOnJMRIWebServer"));
        this._openHelpOnJMRIWebServerRadioButton.setToolTipText(Bundle.getMessage("Help_ToolTipLabelOpenHelpOnJMRIWebServer"));
        this._openHelpButtonGroup.add(this._openHelpOnJMRIWebServerRadioButton);
        JPanel gridPanel = new JPanel(new GridLayout(0, 1));
        gridPanel.add(this._openHelpOnFileRadioButton);
        gridPanel.add(this._openHelpOnlineRadioButton);
        gridPanel.add(this._openHelpOnJMRIWebServerRadioButton);
        this._openHelpOnFileRadioButton.setSelected(this._preferences.getOpenHelpOnFile());
        this._openHelpOnlineRadioButton.setSelected(this._preferences.getOpenHelpOnline());
        this._openHelpOnJMRIWebServerRadioButton.setSelected(this._preferences.getOpenHelpOnJMRIWebServer());
        panel.setLayout(new FlowLayout(1, 40, 0));
        panel.add(gridPanel);
        return panel;
    }

    @Override
    public String getPreferencesItem() {
        return "HELP";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("MenuHelp");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return this.getPreferencesItemText();
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        if (this.setValues()) {
            this._preferences.save();
        }
    }

    @Override
    public boolean isDirty() {
        return this._preferences.isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return this._preferences.isRestartRequired();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }
}

