/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.Version;
import jmri.beans.Bean;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.FileUtil;
import jmri.util.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtilSupport
extends Bean {
    private static final String HOME_PATH = String.valueOf(System.getProperty("user.home")) + File.separator;
    private String programPath = null;
    private String jarPath = null;
    private final HashMap<Profile, String> scriptsPaths = new HashMap();
    private final HashMap<Profile, String> userFilesPaths = new HashMap();
    private final HashMap<Profile, String> profilePaths = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(FileUtilSupport.class);
    private static volatile FileUtilSupport defaultInstance = null;

    public FileUtilSupport() {
        super(false);
    }

    @Nonnull
    @CheckReturnValue
    public File getFile(@Nonnull String path) throws FileNotFoundException {
        return this.getFile(ProfileManager.getDefault().getActiveProfile(), path);
    }

    @Nonnull
    @CheckReturnValue
    public File getFile(@CheckForNull Profile profile, @Nonnull String path) throws FileNotFoundException {
        try {
            return new File(this.pathFromPortablePath(profile, path));
        }
        catch (NullPointerException nullPointerException) {
            throw new FileNotFoundException("Cannot find file at " + path);
        }
    }

    @Nonnull
    @CheckReturnValue
    public URI getURI(@Nonnull String path) throws FileNotFoundException {
        return this.getFile(path).toURI();
    }

    @Nonnull
    @CheckReturnValue
    public URL getURL(@Nonnull String path) throws FileNotFoundException {
        try {
            return this.getURI(path).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileNotFoundException("Cannot create URL for file at " + path);
        }
    }

    @CheckForNull
    @CheckReturnValue
    public URL getURL(@Nonnull URI uri) {
        try {
            return uri.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            log.warn("Unable to get URL from {}", (Object)uri);
            return null;
        }
        catch (NullPointerException ex) {
            log.warn("Unable to get URL from null object.", (Throwable)ex);
            return null;
        }
    }

    @Nonnull
    @CheckReturnValue
    public Set<File> findFiles(@Nonnull String name, @Nonnull String root) throws IllegalArgumentException {
        return this.findFiles(name, root, FileUtil.Location.ALL);
    }

    @Nonnull
    @CheckReturnValue
    public Set<File> findFiles(@Nonnull String name, @Nonnull String root, @Nonnull FileUtil.Location location) {
        Objects.requireNonNull(name, "name must be nonnull");
        Objects.requireNonNull(root, "root must be nonnull");
        Objects.requireNonNull(location, "location must be nonnull");
        if (location == FileUtil.Location.NONE) {
            throw new IllegalArgumentException("location must not be NONE");
        }
        if (root.isEmpty() || root.contains("..") || root.startsWith("/")) {
            throw new IllegalArgumentException("root is invalid");
        }
        if (name.isEmpty() || name.contains(File.pathSeparator) || name.contains("/")) {
            throw new IllegalArgumentException("name is invalid");
        }
        HashSet<File> files = new HashSet<File>();
        if (location == FileUtil.Location.INSTALLED || location == FileUtil.Location.ALL) {
            files.addAll(this.findFiles(name, new File(this.findURI("program:" + root, FileUtil.Location.NONE))));
        }
        if (location == FileUtil.Location.USER || location == FileUtil.Location.ALL) {
            try {
                files.addAll(this.findFiles(name, new File(this.findURI("preference:" + root, FileUtil.Location.NONE))));
            }
            catch (NullPointerException nullPointerException) {
                log.trace("{} does not exist in {}", (Object)root, (Object)"preference:");
            }
            try {
                files.addAll(this.findFiles(name, new File(this.findURI("profile:" + root, FileUtil.Location.NONE))));
            }
            catch (NullPointerException nullPointerException) {
                log.trace("{} does not exist in {}", (Object)root, (Object)"profile:");
            }
            try {
                files.addAll(this.findFiles(name, new File(this.findURI("settings:" + root, FileUtil.Location.NONE))));
            }
            catch (NullPointerException nullPointerException) {
                log.trace("{} does not exist in {}", (Object)root, (Object)"settings:");
            }
        }
        return files;
    }

    private Set<File> findFiles(final String name, File root) {
        final HashSet<File> files = new HashSet<File>();
        if (root.isDirectory()) {
            try {
                Files.walkFileTree(root.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path fn = dir.getFileName();
                        if (fn != null && name.equals(fn.toString())) {
                            files.add(dir.toFile().getCanonicalFile());
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path fn = file.getFileName();
                        if (fn != null && name.equals(fn.toString())) {
                            files.add(file.toFile().getCanonicalFile());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                log.warn("Exception while finding file {} in {}", new Object[]{name, root, ex});
            }
        }
        return files;
    }

    @Nonnull
    @CheckReturnValue
    public String getExternalFilename(@Nonnull String pName) {
        return this.getExternalFilename(ProfileManager.getDefault().getActiveProfile(), pName);
    }

    @Nonnull
    @CheckReturnValue
    public String getExternalFilename(@CheckForNull Profile profile, @Nonnull String pName) {
        String filename = this.pathFromPortablePath(profile, pName);
        return filename != null ? filename : pName.replace('/', File.separatorChar);
    }

    @Nonnull
    @CheckReturnValue
    public String getAbsoluteFilename(@Nonnull String path) {
        return this.getAbsoluteFilename(ProfileManager.getDefault().getActiveProfile(), path);
    }

    @Nonnull
    @CheckReturnValue
    public String getAbsoluteFilename(@CheckForNull Profile profile, @Nonnull String path) {
        return this.pathFromPortablePath(profile, path);
    }

    @Nonnull
    @CheckReturnValue
    public String getPortableFilename(@Nonnull File file) {
        return this.getPortableFilename(ProfileManager.getDefault().getActiveProfile(), file, false, false);
    }

    @Nonnull
    @CheckReturnValue
    public String getPortableFilename(@Nonnull File file, boolean ignoreUserFilesPath, boolean ignoreProfilePath) {
        return this.getPortableFilename(ProfileManager.getDefault().getActiveProfile(), file, ignoreUserFilesPath, ignoreProfilePath);
    }

    @Nonnull
    @CheckReturnValue
    public String getPortableFilename(@Nonnull String filename) {
        return this.getPortableFilename(ProfileManager.getDefault().getActiveProfile(), filename, false, false);
    }

    @Nonnull
    @CheckReturnValue
    public String getPortableFilename(@Nonnull String filename, boolean ignoreUserFilesPath, boolean ignoreProfilePath) {
        if (this.isPortableFilename(filename)) {
            return this.getPortableFilename(this.getExternalFilename(filename), ignoreUserFilesPath, ignoreProfilePath);
        }
        return this.getPortableFilename(new File(filename), ignoreUserFilesPath, ignoreProfilePath);
    }

    @Nonnull
    @CheckReturnValue
    public String getPortableFilename(@CheckForNull Profile profile, @Nonnull File file) {
        return this.getPortableFilename(profile, file, false, false);
    }

    @Nonnull
    @CheckReturnValue
    public String getPortableFilename(@CheckForNull Profile profile, @Nonnull File file, boolean ignoreUserFilesPath, boolean ignoreProfilePath) {
        String filename = file.getAbsolutePath();
        if (file.isDirectory()) {
            filename = String.valueOf(filename) + File.separator;
        }
        if (filename == null) {
            throw new IllegalArgumentException("File \"" + file + "\" has a null absolute path which is not allowed");
        }
        if (!ignoreUserFilesPath && filename.startsWith(this.getUserFilesPath(profile))) {
            return "preference:" + filename.substring(this.getUserFilesPath(profile).length(), filename.length()).replace(File.separatorChar, '/');
        }
        if (!ignoreProfilePath && filename.startsWith(this.getProfilePath(profile))) {
            return "profile:" + filename.substring(this.getProfilePath(profile).length(), filename.length()).replace(File.separatorChar, '/');
        }
        if (filename.startsWith(this.getPreferencesPath())) {
            return "settings:" + filename.substring(this.getPreferencesPath().length(), filename.length()).replace(File.separatorChar, '/');
        }
        if (!ignoreUserFilesPath && filename.startsWith(this.getScriptsPath(profile)) && !filename.equals(this.getScriptsPath(profile))) {
            return "scripts:" + filename.substring(this.getScriptsPath(profile).length(), filename.length()).replace(File.separatorChar, '/');
        }
        if (filename.startsWith(this.getProgramPath())) {
            return "program:" + filename.substring(this.getProgramPath().length(), filename.length()).replace(File.separatorChar, '/');
        }
        if (filename.startsWith(this.getHomePath())) {
            return "home:" + filename.substring(this.getHomePath().length(), filename.length()).replace(File.separatorChar, '/');
        }
        return filename.replace(File.separatorChar, '/');
    }

    @Nonnull
    @CheckReturnValue
    public String getPortableFilename(@CheckForNull Profile profile, @Nonnull String filename) {
        return this.getPortableFilename(profile, filename, false, false);
    }

    @Nonnull
    @CheckReturnValue
    public String getPortableFilename(@CheckForNull Profile profile, @Nonnull String filename, boolean ignoreUserFilesPath, boolean ignoreProfilePath) {
        if (this.isPortableFilename(filename)) {
            return this.getPortableFilename(profile, this.getExternalFilename(filename), ignoreUserFilesPath, ignoreProfilePath);
        }
        return this.getPortableFilename(profile, new File(filename), ignoreUserFilesPath, ignoreProfilePath);
    }

    public boolean isPortableFilename(@Nonnull String filename) {
        return filename.startsWith("program:") || filename.startsWith("home:") || filename.startsWith("preference:") || filename.startsWith("scripts:") || filename.startsWith("profile:") || filename.startsWith("settings:");
    }

    @Nonnull
    @CheckReturnValue
    public String getHomePath() {
        return HOME_PATH;
    }

    @Nonnull
    @CheckReturnValue
    public String getUserFilesPath() {
        return this.getUserFilesPath(ProfileManager.getDefault().getActiveProfile());
    }

    @Nonnull
    @CheckReturnValue
    public String getUserFilesPath(@CheckForNull Profile profile) {
        String path = this.userFilesPaths.get(profile);
        return path != null ? path : this.getProfilePath(profile);
    }

    public void setUserFilesPath(@CheckForNull Profile profile, @Nonnull String path) {
        String old = this.userFilesPaths.get(profile);
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        this.userFilesPaths.put(profile, path);
        if (old != null && !old.equals(path) || !path.equals(old)) {
            this.firePropertyChange("preference:", new FileUtil.Property(profile, old), new FileUtil.Property(profile, path));
        }
    }

    @Nonnull
    @CheckReturnValue
    public String getProfilePath(@CheckForNull Profile profile) {
        String path = this.profilePaths.get(profile);
        if (path == null) {
            File f;
            File file = f = profile != null ? profile.getPath() : null;
            if (f != null) {
                path = f.getAbsolutePath();
                if (!path.endsWith(File.separator)) {
                    path = String.valueOf(path) + File.separator;
                }
                this.profilePaths.put(profile, path);
            }
        }
        return path != null ? path : this.getPreferencesPath();
    }

    @Nonnull
    @CheckReturnValue
    public String getProfilePath() {
        return this.getProfilePath(ProfileManager.getDefault().getActiveProfile());
    }

    @Deprecated
    public void setProfilePath(@CheckForNull String path) {
    }

    @Nonnull
    @CheckReturnValue
    public String getPreferencesPath() {
        String result;
        block7: {
            String jmriPrefsDir = System.getProperty("jmri.prefsdir", "");
            if (!jmriPrefsDir.isEmpty()) {
                try {
                    return String.valueOf(new File(jmriPrefsDir).getCanonicalPath()) + File.separator;
                }
                catch (IOException iOException) {
                    System.err.println("Unable to locate settings dir \"" + jmriPrefsDir + "\"");
                    if (jmriPrefsDir.endsWith(File.separator)) break block7;
                    return String.valueOf(jmriPrefsDir) + File.separator;
                }
            }
        }
        switch (SystemType.getType()) {
            case 2: {
                result = String.valueOf(this.getHomePath()) + "Library" + File.separator + "Preferences" + File.separator + "JMRI" + File.separator;
                break;
            }
            case 5: 
            case 7: {
                result = String.valueOf(this.getHomePath()) + ".jmri" + File.separator;
                break;
            }
            default: {
                result = String.valueOf(this.getHomePath()) + "JMRI" + File.separator;
            }
        }
        return result;
    }

    @Nonnull
    public File getCacheDirectory() {
        File cache;
        String property = System.getProperty("jmri_default_cachedir");
        if (property != null) {
            cache = new File(property);
        } else {
            switch (SystemType.getType()) {
                case 2: {
                    cache = new File(new File(this.getHomePath(), "Library/Caches/JMRI"), Version.getCanonicalVersion());
                    break;
                }
                case 5: 
                case 7: {
                    property = System.getenv("XDG_CACHE_HOME");
                    if (property != null) {
                        cache = new File(new File(property, "JMRI"), Version.getCanonicalVersion());
                        break;
                    }
                    cache = new File(new File(this.getHomePath(), ".cache/JMRI"), Version.getCanonicalVersion());
                    break;
                }
                case 4: {
                    try {
                        cache = new File(new File(Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_LocalAppData), "JMRI/cache"), Version.getCanonicalVersion());
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        cache = new File(new File(Shell32Util.getFolderPath((int)28), "JMRI/cache"), Version.getCanonicalVersion());
                    }
                    break;
                }
                default: {
                    cache = new File(new File(this.getPreferencesPath(), "cache"), Version.getCanonicalVersion());
                }
            }
        }
        this.createDirectory(cache);
        return cache;
    }

    @Nonnull
    @CheckReturnValue
    public String getProgramPath() {
        if (this.programPath == null) {
            this.setProgramPath(System.getProperty("jmri.path.program", "."));
        }
        return this.programPath;
    }

    public void setProgramPath(@Nonnull String path) {
        this.setProgramPath(new File(path));
    }

    public void setProgramPath(@Nonnull File path) {
        String old = this.programPath;
        try {
            this.programPath = String.valueOf(path.getCanonicalPath()) + File.separator;
        }
        catch (IOException ex) {
            log.error("Unable to get JMRI program directory.", (Throwable)ex);
        }
        if (old != null && !old.equals(this.programPath) || this.programPath != null && !this.programPath.equals(old)) {
            this.firePropertyChange("program:", old, this.programPath);
        }
    }

    @Nonnull
    @CheckReturnValue
    public String getUserResourcePath() {
        return String.valueOf(this.getUserFilesPath()) + "resources" + File.separator;
    }

    public void logFilePaths() {
        log.info("File path {} is {}", (Object)"program:", (Object)this.getProgramPath());
        log.info("File path {} is {}", (Object)"preference:", (Object)this.getUserFilesPath());
        log.info("File path {} is {}", (Object)"profile:", (Object)this.getProfilePath());
        log.info("File path {} is {}", (Object)"settings:", (Object)this.getPreferencesPath());
        log.info("File path {} is {}", (Object)"home:", (Object)this.getHomePath());
        log.info("File path {} is {}", (Object)"scripts:", (Object)this.getScriptsPath());
    }

    @Nonnull
    @CheckReturnValue
    public String getScriptsPath() {
        return this.getScriptsPath(ProfileManager.getDefault().getActiveProfile());
    }

    @Nonnull
    @CheckReturnValue
    public String getScriptsPath(@CheckForNull Profile profile) {
        String path = this.scriptsPaths.get(profile);
        if (path != null) {
            return path;
        }
        File file = new File(String.valueOf(this.getProgramPath()) + File.separator + "jython" + File.separator);
        if (file.exists() && file.isDirectory()) {
            return String.valueOf(file.getPath()) + File.separator;
        }
        return this.getUserFilesPath();
    }

    public void setScriptsPath(@CheckForNull Profile profile, @CheckForNull String path) {
        String old = this.scriptsPaths.get(profile);
        if (path != null && !path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        this.scriptsPaths.put(profile, path);
        if (old != null && !old.equals(path) || path != null && !path.equals(old)) {
            this.firePropertyChange("scripts:", new FileUtil.Property(profile, old), new FileUtil.Property(profile, path));
        }
    }

    @Nonnull
    @CheckReturnValue
    public URI findExternalFilename(@Nonnull String path) {
        block19: {
            log.debug("Finding external path {}", (Object)path);
            if (!this.isPortableFilename(path)) break block19;
            int index = path.indexOf(":") + 1;
            String location = path.substring(0, index);
            path = path.substring(index);
            log.debug("Finding {} and {}", (Object)location, (Object)path);
            switch (location) {
                case "program:": {
                    return this.findURI(path, FileUtil.Location.INSTALLED);
                }
                case "preference:": {
                    return this.findURI(path, FileUtil.Location.USER);
                }
                case "profile:": 
                case "scripts:": 
                case "home:": 
                case "settings:": {
                    return this.findURI(this.getExternalFilename(String.valueOf(location) + path));
                }
            }
        }
        return this.findURI(path, FileUtil.Location.ALL);
    }

    public InputStream findInputStream(@Nonnull String path) {
        return this.findInputStream(path, new String[0]);
    }

    public InputStream findInputStream(@Nonnull String path, String ... searchPaths) {
        return this.findInputStream(path, FileUtil.Location.ALL, searchPaths);
    }

    public InputStream findInputStream(@Nonnull String path, @Nonnull FileUtil.Location locations) {
        return this.findInputStream(path, locations, new String[0]);
    }

    public InputStream findInputStream(@Nonnull String path, @Nonnull FileUtil.Location locations, String ... searchPaths) {
        URL file = this.findURL(path, locations, searchPaths);
        if (file != null) {
            try {
                return file.openStream();
            }
            catch (IOException ex) {
                log.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    public URI findURI(@Nonnull String path) {
        return this.findURI(path, new String[0]);
    }

    public URI findURI(@Nonnull String path, String ... searchPaths) {
        return this.findURI(path, FileUtil.Location.ALL, searchPaths);
    }

    public URI findURI(@Nonnull String path, @Nonnull FileUtil.Location locations) {
        return this.findURI(path, locations, new String[0]);
    }

    public URI findURI(@Nonnull String path, @Nonnull FileUtil.Location locations, String ... searchPaths) {
        File file;
        if (log.isDebugEnabled()) {
            log.debug("Attempting to find {} in {}", (Object)path, (Object)Arrays.toString(searchPaths));
        }
        if (this.isPortableFilename(path)) {
            try {
                return this.findExternalFilename(path);
            }
            catch (NullPointerException nullPointerException) {}
        }
        URI resource = null;
        String[] stringArray = searchPaths;
        int n = searchPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String searchPath = stringArray[n2];
            resource = this.findURI(String.valueOf(searchPath) + File.separator + path);
            if (resource != null) {
                return resource;
            }
            ++n2;
        }
        if (locations == FileUtil.Location.ALL || locations == FileUtil.Location.USER) {
            file = new File(this.getUserFilesPath(), path);
            if (file.exists()) {
                return file.toURI();
            }
            file = new File(this.getProfilePath(), path);
            if (file.exists()) {
                return file.toURI();
            }
            file = new File(this.getPreferencesPath(), path);
            if (file.exists()) {
                return file.toURI();
            }
        }
        if (locations == FileUtil.Location.ALL || locations == FileUtil.Location.INSTALLED) {
            file = new File(path);
            if (file.exists()) {
                return file.toURI();
            }
            file = new File(String.valueOf(this.getProgramPath()) + path);
            if (file.exists()) {
                return file.toURI();
            }
        }
        if (locations == FileUtil.Location.ALL || locations == FileUtil.Location.INSTALLED) {
            path = path.replace(File.separatorChar, '/');
            URL url = FileUtilSupport.class.getClassLoader().getResource(path);
            if (url == null && (url = FileUtilSupport.class.getResource(path)) == null) {
                log.debug("{} not found in classpath", (Object)path);
            }
            try {
                resource = url != null ? url.toURI() : null;
            }
            catch (URISyntaxException ex) {
                log.warn("Unable to get URI for {}", (Object)path, (Object)ex);
            }
        }
        if (resource == null && (file = new File(path)).isAbsolute() && file.exists()) {
            return file.toURI();
        }
        return resource;
    }

    public URL findURL(@Nonnull String path) {
        return this.findURL(path, new String[0]);
    }

    public URL findURL(@Nonnull String path, String ... searchPaths) {
        return this.findURL(path, FileUtil.Location.ALL, searchPaths);
    }

    public URL findURL(@Nonnull String path, FileUtil.Location locations) {
        return this.findURL(path, locations, new String[0]);
    }

    public URL findURL(@Nonnull String path, @Nonnull FileUtil.Location locations, String ... searchPaths) {
        URI file = this.findURI(path, locations, searchPaths);
        if (file != null) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException ex) {
                log.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    public URI urlToURI(@Nonnull URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            log.error("Unable to get URI from URL", (Throwable)ex);
            return null;
        }
    }

    public URL fileToURL(@Nonnull File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            log.error("Unable to get URL from file", (Throwable)ex);
            return null;
        }
    }

    public JarFile getJmriJarFile() {
        if (this.jarPath == null) {
            CodeSource sc = FileUtilSupport.class.getProtectionDomain().getCodeSource();
            if (sc != null) {
                this.jarPath = sc.getLocation().toString();
                if (!this.jarPath.startsWith("jar:file:")) {
                    log.info("Running from classes not in jar file.");
                    this.jarPath = "";
                    return null;
                }
                this.jarPath = this.jarPath.substring(9, this.jarPath.lastIndexOf("!"));
                log.debug("jmri.jar path is {}", (Object)this.jarPath);
            }
            if (this.jarPath == null) {
                log.error("Unable to locate jmri.jar");
                this.jarPath = "";
                return null;
            }
        }
        if (!this.jarPath.isEmpty()) {
            try {
                return new JarFile(this.jarPath);
            }
            catch (IOException ex) {
                log.error("Unable to open jmri.jar", (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public String readFile(@Nonnull File file) throws IOException {
        return this.readURL(this.fileToURL(file));
    }

    /*
     * Loose catch block
     */
    public String readURL(@Nonnull URL url) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                String string;
                BufferedReader reader;
                InputStreamReader in;
                block18: {
                    block17: {
                        in = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
                        reader = new BufferedReader(in);
                        string = reader.lines().collect(Collectors.joining("\n"));
                        if (reader == null) break block17;
                        reader.close();
                    }
                    if (in == null) break block18;
                    in.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (in != null) {
                                in.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Nonnull
    public String sanitizeFilename(@Nonnull String name) {
        name = name.trim().replaceAll(" ", "_").replaceAll("[.]+", ".");
        StringBuilder filename = new StringBuilder();
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '.' || Character.isJavaIdentifierPart(c)) {
                filename.append(c);
            }
            ++n2;
        }
        return filename.toString();
    }

    public void createDirectory(@Nonnull String path) {
        this.createDirectory(new File(path));
    }

    public void createDirectory(@Nonnull File dir) {
        if (!dir.exists()) {
            log.debug("Creating directory: {}", (Object)dir);
            if (!dir.mkdirs()) {
                log.error("Failed to create directory: {}", (Object)dir);
            }
        }
    }

    public boolean delete(@Nonnull File path) {
        File[] files;
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.delete(file);
                ++n2;
            }
        }
        return path.delete();
    }

    public void copy(@Nonnull File source, @Nonnull File dest) throws IOException {
        if (!source.exists()) {
            log.error("Attempting to copy non-existant file: {}", (Object)source);
            return;
        }
        if (!dest.exists()) {
            boolean ok;
            if (source.isDirectory()) {
                ok = dest.mkdirs();
                if (!ok) {
                    throw new IOException("Could not use mkdirs to create destination directory");
                }
            } else {
                ok = dest.createNewFile();
                if (!ok) {
                    throw new IOException("Could not create destination file");
                }
            }
        }
        final Path srcPath = source.toPath();
        final Path dstPath = dest.toPath();
        if (source.isDirectory()) {
            Files.walkFileTree(srcPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(dstPath.resolve(srcPath.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, dstPath.resolve(srcPath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            Files.copy(source.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void appendTextToFile(@Nonnull File file, @Nonnull String text) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8));){
            pw.println(text);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void backup(@Nonnull File file) throws IOException {
        this.rotate(file, 4, "bak");
    }

    public void rotate(@Nonnull File file, int max, @CheckForNull String extension) throws IOException {
        if (max < 1) {
            throw new IllegalArgumentException();
        }
        String name = file.getName();
        if (extension != null) {
            if (extension.length() > 0 && !extension.startsWith(".")) {
                extension = "." + extension;
            }
        } else {
            extension = "";
        }
        File dir = file.getParentFile();
        int i = max;
        while (i > 1) {
            File source = new File(dir, String.valueOf(name) + "." + (i - 1) + extension);
            if (source.exists()) {
                this.copy(source, new File(dir, String.valueOf(name) + "." + i + extension));
            }
            --i;
        }
        this.copy(file, new File(dir, String.valueOf(name) + "." + i + extension));
    }

    public static FileUtilSupport getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new FileUtilSupport();
        }
        return defaultInstance;
    }

    private String pathFromPortablePath(@CheckForNull Profile profile, @Nonnull String path) {
        if (path.startsWith("program:")) {
            path = new File(path.substring("program:".length())).isAbsolute() ? path.substring("program:".length()) : path.replaceFirst("program:", Matcher.quoteReplacement(this.getProgramPath()));
        } else if (path.startsWith("preference:")) {
            path = new File(path.substring("preference:".length())).isAbsolute() ? path.substring("preference:".length()) : path.replaceFirst("preference:", Matcher.quoteReplacement(this.getUserFilesPath(profile)));
        } else if (path.startsWith("profile:")) {
            path = new File(path.substring("profile:".length())).isAbsolute() ? path.substring("profile:".length()) : path.replaceFirst("profile:", Matcher.quoteReplacement(this.getProfilePath(profile)));
        } else if (path.startsWith("scripts:")) {
            path = new File(path.substring("scripts:".length())).isAbsolute() ? path.substring("scripts:".length()) : path.replaceFirst("scripts:", Matcher.quoteReplacement(this.getScriptsPath(profile)));
        } else if (path.startsWith("settings:")) {
            path = new File(path.substring("settings:".length())).isAbsolute() ? path.substring("settings:".length()) : path.replaceFirst("settings:", Matcher.quoteReplacement(this.getPreferencesPath()));
        } else if (path.startsWith("home:")) {
            path = new File(path.substring("home:".length())).isAbsolute() ? path.substring("home:".length()) : path.replaceFirst("home:", Matcher.quoteReplacement(this.getHomePath()));
        } else if (!new File(path).isAbsolute()) {
            return null;
        }
        try {
            log.debug("Using {}", (Object)path);
            return new File(path.replace('/', File.separatorChar)).getCanonicalPath();
        }
        catch (IOException ex) {
            log.warn("Cannot convert {} into a usable filename.", (Object)path, (Object)ex);
            return null;
        }
    }
}

