/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.profile.Profile;
import jmri.util.FileUtilSupport;

public final class FileUtil {
    public static final String PROGRAM = "program:";
    public static final String PREFERENCES = "preference:";
    public static final String SETTINGS = "settings:";
    public static final String HOME = "home:";
    public static final String PROFILE = "profile:";
    public static final String SCRIPTS = "scripts:";
    public static final char SEPARATOR = '/';

    @Nonnull
    @CheckReturnValue
    public static File getFile(@Nonnull String path) throws FileNotFoundException {
        return FileUtilSupport.getDefault().getFile(path);
    }

    @Nonnull
    @CheckReturnValue
    public static File getFile(@CheckForNull Profile profile, @Nonnull String path) throws FileNotFoundException {
        return FileUtilSupport.getDefault().getFile(profile, path);
    }

    @Nonnull
    @CheckReturnValue
    public static URI getURI(@Nonnull String path) throws FileNotFoundException {
        return FileUtilSupport.getDefault().getURI(path);
    }

    @Nonnull
    @CheckReturnValue
    public static URL getURL(@Nonnull String path) throws FileNotFoundException {
        return FileUtilSupport.getDefault().getURL(path);
    }

    @CheckForNull
    @CheckReturnValue
    public static URL getURL(@Nonnull URI uri) {
        return FileUtilSupport.getDefault().getURL(uri);
    }

    @Nonnull
    @CheckReturnValue
    public static Set<File> findFiles(@Nonnull String name, @Nonnull String root) throws IllegalArgumentException {
        return FileUtilSupport.getDefault().findFiles(name, root);
    }

    @Nonnull
    @CheckReturnValue
    public static Set<File> findFiles(@Nonnull String name, @Nonnull String root, @Nonnull Location location) {
        return FileUtilSupport.getDefault().findFiles(name, root, location);
    }

    @Nonnull
    @CheckReturnValue
    public static String getExternalFilename(@Nonnull String pName) {
        return FileUtilSupport.getDefault().getExternalFilename(pName);
    }

    @Nonnull
    @CheckReturnValue
    public static String getExternalFilename(@CheckForNull Profile profile, @Nonnull String pName) {
        return FileUtilSupport.getDefault().getExternalFilename(profile, pName);
    }

    @Nonnull
    @CheckReturnValue
    public static String getAbsoluteFilename(@Nonnull String path) {
        return FileUtilSupport.getDefault().getAbsoluteFilename(path);
    }

    @Nonnull
    @CheckReturnValue
    public static String getAbsoluteFilename(@CheckForNull Profile profile, @Nonnull String path) {
        return FileUtilSupport.getDefault().getAbsoluteFilename(profile, path);
    }

    @Nonnull
    @CheckReturnValue
    public static String getPortableFilename(@Nonnull File file) {
        return FileUtilSupport.getDefault().getPortableFilename(file);
    }

    @Nonnull
    @CheckReturnValue
    public static String getPortableFilename(@Nonnull File file, boolean ignoreUserFilesPath, boolean ignoreProfilePath) {
        return FileUtilSupport.getDefault().getPortableFilename(file, ignoreUserFilesPath, ignoreProfilePath);
    }

    @Nonnull
    @CheckReturnValue
    public static String getPortableFilename(@Nonnull String filename) {
        return FileUtilSupport.getDefault().getPortableFilename(filename);
    }

    @Nonnull
    @CheckReturnValue
    public static String getPortableFilename(@Nonnull String filename, boolean ignoreUserFilesPath, boolean ignoreProfilePath) {
        return FileUtilSupport.getDefault().getPortableFilename(filename, ignoreUserFilesPath, ignoreProfilePath);
    }

    @Nonnull
    @CheckReturnValue
    public static String getPortableFilename(@CheckForNull Profile profile, @Nonnull File file) {
        return FileUtilSupport.getDefault().getPortableFilename(profile, file);
    }

    @Nonnull
    @CheckReturnValue
    public static String getPortableFilename(@CheckForNull Profile profile, @Nonnull File file, boolean ignoreUserFilesPath, boolean ignoreProfilePath) {
        return FileUtilSupport.getDefault().getPortableFilename(profile, file, ignoreUserFilesPath, ignoreProfilePath);
    }

    @Nonnull
    @CheckReturnValue
    public static String getPortableFilename(@CheckForNull Profile profile, @Nonnull String filename) {
        return FileUtilSupport.getDefault().getPortableFilename(profile, filename);
    }

    @Nonnull
    @CheckReturnValue
    public static String getPortableFilename(@CheckForNull Profile profile, @Nonnull String filename, boolean ignoreUserFilesPath, boolean ignoreProfilePath) {
        return FileUtilSupport.getDefault().getPortableFilename(profile, filename, ignoreUserFilesPath, ignoreProfilePath);
    }

    public static boolean isPortableFilename(@Nonnull String filename) {
        return FileUtilSupport.getDefault().isPortableFilename(filename);
    }

    @Nonnull
    @CheckReturnValue
    public static String getHomePath() {
        return FileUtilSupport.getDefault().getHomePath();
    }

    @Nonnull
    @CheckReturnValue
    public static String getUserFilesPath() {
        return FileUtilSupport.getDefault().getUserFilesPath();
    }

    @Nonnull
    @CheckReturnValue
    public static String getUserFilesPath(@CheckForNull Profile profile) {
        return FileUtilSupport.getDefault().getUserFilesPath(profile);
    }

    public static void setUserFilesPath(@CheckForNull Profile profile, @Nonnull String path) {
        FileUtilSupport.getDefault().setUserFilesPath(profile, path);
    }

    @Nonnull
    @CheckReturnValue
    public static String getProfilePath() {
        return FileUtilSupport.getDefault().getProfilePath();
    }

    @Nonnull
    @CheckReturnValue
    public static String getProfilePath(@CheckForNull Profile profile) {
        return FileUtilSupport.getDefault().getProfilePath(profile);
    }

    @Deprecated
    public static void setProfilePath(@CheckForNull String path) {
    }

    @Nonnull
    @CheckReturnValue
    public static String getPreferencesPath() {
        return FileUtilSupport.getDefault().getPreferencesPath();
    }

    @Nonnull
    @CheckReturnValue
    public static String getProgramPath() {
        return FileUtilSupport.getDefault().getProgramPath();
    }

    public static void setProgramPath(@Nonnull String path) {
        FileUtilSupport.getDefault().setProgramPath(new File(path));
    }

    public static void setProgramPath(@Nonnull File path) {
        FileUtilSupport.getDefault().setProgramPath(path);
    }

    @Nonnull
    @CheckReturnValue
    public static URI findExternalFilename(@Nonnull String path) {
        return FileUtilSupport.getDefault().findExternalFilename(path);
    }

    public static InputStream findInputStream(@Nonnull String path) {
        return FileUtilSupport.getDefault().findInputStream(path);
    }

    public static InputStream findInputStream(@Nonnull String path, String ... searchPaths) {
        return FileUtilSupport.getDefault().findInputStream(path, searchPaths);
    }

    public static InputStream findInputStream(@Nonnull String path, Location locations) {
        return FileUtilSupport.getDefault().findInputStream(path, locations);
    }

    public static InputStream findInputStream(@Nonnull String path, Location locations, String ... searchPaths) {
        return FileUtilSupport.getDefault().findInputStream(path, locations, searchPaths);
    }

    @Nonnull
    @CheckReturnValue
    public static String getUserResourcePath() {
        return FileUtilSupport.getDefault().getUserResourcePath();
    }

    public static URI findURI(@Nonnull String path) {
        return FileUtilSupport.getDefault().findURI(path);
    }

    public static URI findURI(@Nonnull String path, String ... searchPaths) {
        return FileUtilSupport.getDefault().findURI(path, searchPaths);
    }

    public static URI findURI(@Nonnull String path, @Nonnull Location locations) {
        return FileUtilSupport.getDefault().findURI(path, locations);
    }

    public static URI findURI(@Nonnull String path, @Nonnull Location locations, String ... searchPaths) {
        return FileUtilSupport.getDefault().findURI(path, locations, searchPaths);
    }

    public static URL findURL(@Nonnull String path) {
        return FileUtilSupport.getDefault().findURL(path);
    }

    public static URL findURL(@Nonnull String path, String ... searchPaths) {
        return FileUtilSupport.getDefault().findURL(path, searchPaths);
    }

    public static URL findURL(@Nonnull String path, @Nonnull Location locations) {
        return FileUtilSupport.getDefault().findURL(path, locations);
    }

    public static URL findURL(@Nonnull String path, @Nonnull Location locations, String ... searchPaths) {
        return FileUtilSupport.getDefault().findURL(path, locations, searchPaths);
    }

    public static URI urlToURI(@Nonnull URL url) {
        return FileUtilSupport.getDefault().urlToURI(url);
    }

    public static URL fileToURL(@Nonnull File file) {
        return FileUtilSupport.getDefault().fileToURL(file);
    }

    public static JarFile jmriJarFile() {
        return FileUtilSupport.getDefault().getJmriJarFile();
    }

    public static void logFilePaths() {
        FileUtilSupport.getDefault().logFilePaths();
    }

    @Nonnull
    @CheckReturnValue
    public static String getScriptsPath() {
        return FileUtilSupport.getDefault().getScriptsPath();
    }

    @Nonnull
    @CheckReturnValue
    public static String getScriptsPath(@CheckForNull Profile profile) {
        return FileUtilSupport.getDefault().getScriptsPath(profile);
    }

    public static void setScriptsPath(@CheckForNull Profile profile, @CheckForNull String path) {
        FileUtilSupport.getDefault().setScriptsPath(profile, path);
    }

    public static String readFile(@Nonnull File file) throws IOException {
        return FileUtil.readURL(FileUtil.fileToURL(file));
    }

    public static String readURL(@Nonnull URL url) throws IOException {
        return FileUtilSupport.getDefault().readURL(url);
    }

    @Nonnull
    public static String sanitizeFilename(@Nonnull String name) {
        return FileUtilSupport.getDefault().sanitizeFilename(name);
    }

    public static void createDirectory(@Nonnull String path) {
        FileUtilSupport.getDefault().createDirectory(path);
    }

    public static void createDirectory(@Nonnull File dir) {
        FileUtilSupport.getDefault().createDirectory(dir);
    }

    public static boolean delete(@Nonnull File path) {
        return FileUtilSupport.getDefault().delete(path);
    }

    public static void copy(@Nonnull File source, @Nonnull File dest) throws IOException {
        FileUtilSupport.getDefault().copy(source, dest);
    }

    public static void appendTextToFile(@Nonnull File file, @Nonnull String text) throws IOException {
        FileUtilSupport.getDefault().appendTextToFile(file, text);
    }

    public static void backup(@Nonnull File file) throws IOException {
        FileUtilSupport.getDefault().backup(file);
    }

    public static void rotate(@Nonnull File file, int max, @CheckForNull String extension) throws IOException {
        FileUtilSupport.getDefault().rotate(file, max, extension);
    }

    public static FileUtilSupport getDefault() {
        return FileUtilSupport.getDefault();
    }

    private FileUtil() {
    }

    public static enum Location {
        INSTALLED,
        USER,
        ALL,
        NONE;

    }

    public static class Property
    implements Map.Entry {
        private final Profile key;
        private final String value;

        Property(Profile key, String value) {
            this.key = key;
            this.value = value;
        }

        public Profile getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Immutable by design");
        }
    }
}

