/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import jmri.util.DnDTableExportHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnDTableImportExportHandler
extends DnDTableExportHandler {
    int[] _skipColumns = new int[0];
    private static final Logger log = LoggerFactory.getLogger(DnDTableImportExportHandler.class);

    public DnDTableImportExportHandler() {
    }

    public DnDTableImportExportHandler(int[] skipCols) {
        if (skipCols != null) {
            this._skipColumns = skipCols;
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        DataFlavor[] flavors = support.getDataFlavors();
        int k = 0;
        while (k < flavors.length) {
            if (flavors[k].equals(DataFlavor.stringFlavor)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        TransferHandler.DropLocation loc = support.getDropLocation();
        Component comp = support.getComponent();
        if (!(support.isDrop() && loc instanceof JTable.DropLocation && comp instanceof JTable)) {
            return false;
        }
        JTable.DropLocation location = (JTable.DropLocation)loc;
        log.debug("importData: location= {} row= {} col= {}", new Object[]{loc.getDropPoint(), location.getRow(), location.getColumn()});
        JTable table = (JTable)comp;
        int row = table.convertRowIndexToModel(location.getRow());
        int col = table.convertColumnIndexToModel(location.getColumn());
        int i = 0;
        while (i < this._skipColumns.length) {
            if (this._skipColumns[i] == col) {
                return false;
            }
            ++i;
        }
        try {
            Transferable trans = support.getTransferable();
            Object obj = trans.getTransferData(DataFlavor.stringFlavor);
            table.getModel().setValueAt(obj, row, col);
            return true;
        }
        catch (UnsupportedFlavorException | IOException ufe) {
            log.warn("DnDStringImportHandler.importData: {}", (Object)ufe.getMessage());
            return false;
        }
    }
}

