/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnDStringImportHandler
extends TransferHandler {
    private static final Logger log = LoggerFactory.getLogger(DnDStringImportHandler.class);

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        int k = 0;
        while (k < transferFlavors.length) {
            if (transferFlavors[k].equals(DataFlavor.stringFlavor)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable tr) {
        DataFlavor[] flavors = tr.getTransferDataFlavors();
        if (!this.canImport(comp, flavors) || !(comp instanceof JTextField)) {
            return false;
        }
        try {
            String data = (String)tr.getTransferData(DataFlavor.stringFlavor);
            JTextField field = (JTextField)comp;
            field.setText(data);
            field.firePropertyChange("DnDrop", 0, 1);
            return true;
        }
        catch (UnsupportedFlavorException | IOException ufe) {
            log.warn("DnDStringImportHandler.importData: {}", (Object)ufe.getMessage());
            return false;
        }
    }
}

