/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvUtil {
    private static final Logger log = LoggerFactory.getLogger((String)CvUtil.class.getName());

    public static List<String> expandCvList(String cvString) {
        ArrayList<String> ret = new ArrayList<String>();
        String prefix = "";
        String theString = cvString;
        String suffix = "";
        Pattern pattern = Pattern.compile("[(),\\-:]");
        Matcher matcher = pattern.matcher(theString);
        if (matcher.find()) {
            pattern = Pattern.compile("^([^(),\\-:]*?)\\(??([^()]*)\\)??([^(),\\-:]*?)$");
            matcher = pattern.matcher(theString);
            if (matcher.find()) {
                prefix = matcher.group(1);
                theString = matcher.group(2);
                suffix = matcher.group(3);
            }
            if ((matcher = (pattern = Pattern.compile("^([^(),\\-:]+?)(,[^(),\\-:]+?)+?$")).matcher(theString)).find()) {
                String[] theArray = theString.split(",");
                int i = 0;
                while (i < theArray.length) {
                    ret.add(String.valueOf(prefix) + theArray[i] + suffix);
                    ++i;
                }
                return ret;
            }
            pattern = Pattern.compile("^([^(),\\-:]*?)(\\d+)-(\\d+)([^(),\\-:]*?)$");
            matcher = pattern.matcher(theString);
            if (matcher.find()) {
                String subPrefix = matcher.group(1);
                int start = Integer.parseInt(matcher.group(2));
                int end = Integer.parseInt(matcher.group(3));
                int inc = 0;
                String subSuffix = matcher.group(4);
                if (start < end) {
                    inc = 1;
                } else if (start > end) {
                    inc = -1;
                }
                int j = start;
                do {
                    ret.add(String.valueOf(prefix) + subPrefix + j + subSuffix + suffix);
                } while ((j += inc) != end + inc);
                return ret;
            }
            pattern = Pattern.compile("^([^(),\\-:]*?)(\\d+):(-?\\d+)([^(),\\-:]*?)$");
            matcher = pattern.matcher(theString);
            if (matcher.find()) {
                String subPrefix = matcher.group(1);
                int start = Integer.parseInt(matcher.group(2));
                int count = Integer.parseInt(matcher.group(3));
                int inc = 0;
                String subSuffix = matcher.group(4);
                if (count > 0) {
                    inc = 1;
                } else if (count < 0) {
                    inc = -1;
                }
                int j = start;
                do {
                    ret.add(String.valueOf(prefix) + subPrefix + j + subSuffix + suffix);
                } while ((j += inc) != start + count);
                return ret;
            }
            pattern = Pattern.compile("[(),\\-:]");
            matcher = pattern.matcher(theString);
            if (!matcher.find()) {
                ret.add(String.valueOf(prefix) + theString + suffix);
            } else {
                log.error("Invalid string '{}'", (Object)cvString);
            }
        }
        return ret;
    }

    public static String addCvDescription(String toolTip, String cvDescription, String mask) {
        String descString = cvDescription;
        String maskDescString = CvUtil.getMaskDescription(mask);
        if (maskDescString.length() > 0 && !cvDescription.endsWith(".")) {
            descString = String.valueOf(descString) + " " + maskDescString;
        }
        if (PaneProgFrame.getShowCvNumbers() && descString != null) {
            toolTip = toolTip == null || toolTip.length() < 1 ? descString : StringUtil.concatTextHtmlAware(toolTip, " (" + descString + ")");
        } else if (toolTip == null) {
            toolTip = "";
        }
        return toolTip;
    }

    public static String getMaskDescription(String mask) {
        StringBuilder maskDescString = new StringBuilder();
        if (mask != null && mask.contains("X")) {
            int lastBit = mask.length() - 1;
            int lastV = -2;
            if (mask.contains("V")) {
                if (mask.indexOf(86) == mask.lastIndexOf(86)) {
                    maskDescString.append("bit ").append(lastBit - mask.indexOf(86));
                } else {
                    maskDescString.append("bits ");
                    int i = 0;
                    while (i <= lastBit) {
                        char descStringLastChar = maskDescString.charAt(maskDescString.length() - 1);
                        if (mask.charAt(lastBit - i) == 'V') {
                            if (descStringLastChar == ' ') {
                                maskDescString.append(i);
                            } else if (lastV == i - 1) {
                                if (descStringLastChar != '-') {
                                    maskDescString.append("-");
                                }
                            } else {
                                maskDescString.append(",").append(i);
                            }
                            lastV = i;
                        }
                        if ((descStringLastChar = maskDescString.charAt(maskDescString.length() - 1)) == '-' && (mask.charAt(lastBit - i) != 'V' || i == lastBit)) {
                            maskDescString.append(lastV);
                        }
                        ++i;
                    }
                }
            } else {
                maskDescString.append("no bits");
            }
            log.trace("{} Mask:{}", (Object)maskDescString, (Object)mask);
        }
        return maskDescString.toString();
    }
}

