/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.SystemConnectionMemo;

public class ConnectionNameFromSystemName {
    @CheckForNull
    public static String getConnectionName(@Nonnull String prefix) {
        SystemConnectionMemo memo = ConnectionNameFromSystemName.getSystemConnectionMemoFromSystemPrefix(prefix);
        if (memo != null) {
            return memo.getUserName();
        }
        return null;
    }

    @CheckForNull
    public static String getPrefixFromName(@Nonnull String name) {
        SystemConnectionMemo memo = ConnectionNameFromSystemName.getSystemConnectionMemoFromUserName(name);
        if (memo != null) {
            return memo.getSystemPrefix();
        }
        return null;
    }

    @CheckForNull
    public static SystemConnectionMemo getSystemConnectionMemoFromSystemPrefix(@Nonnull String systemPrefix) {
        for (SystemConnectionMemo memo : InstanceManager.getList(SystemConnectionMemo.class)) {
            if (!memo.getSystemPrefix().equals(systemPrefix)) continue;
            return memo;
        }
        return null;
    }

    @CheckForNull
    public static SystemConnectionMemo getSystemConnectionMemoFromUserName(@Nonnull String userName) {
        for (SystemConnectionMemo memo : InstanceManager.getList(SystemConnectionMemo.class)) {
            if (!memo.getUserName().equals(userName)) continue;
            return memo;
        }
        return null;
    }
}

