/*
 * Decompiled with CFR 0.152.
 */
package jmri.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class BusyGlassPane
extends JComponent {
    CBListener listener;

    public BusyGlassPane(List<JComponent> components, List<Rectangle> rectangles, Container contentPane, JFrame parent) {
        this.listener = new CBListener(components, rectangles, this, contentPane, parent);
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
    }

    public void dispose() {
        this.removeMouseListener(this.listener);
        this.removeMouseMotionListener(this.listener);
    }

    static class CBListener
    extends MouseInputAdapter {
        JFrame parentFrame;
        List<JComponent> liveComponents;
        List<Rectangle> liveRectangles;
        BusyGlassPane glassPane;
        Container contentPane;
        boolean inDrag = false;

        public CBListener(List<JComponent> objects, List<Rectangle> rectangles, BusyGlassPane glassPane, Container contentPane, JFrame parent) {
            this.parentFrame = parent;
            this.liveComponents = objects;
            this.liveRectangles = rectangles;
            this.glassPane = glassPane;
            this.contentPane = contentPane;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.redispatchMouseEvent(e);
            this.inDrag = false;
        }

        private void redispatchMouseEvent(MouseEvent e) {
            boolean inButton = false;
            Point glassPanePoint = e.getPoint();
            Component component = null;
            Container container = this.contentPane;
            Point containerPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.contentPane);
            int eventID = e.getID();
            component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
            if (component == null) {
                return;
            }
            int i = 0;
            while (i < this.liveComponents.size()) {
                if (component.equals(this.liveComponents.get(i))) {
                    inButton = true;
                    this.testForDrag(eventID);
                }
                ++i;
            }
            i = 0;
            while (i < this.liveRectangles.size()) {
                Rectangle rectangle = this.liveRectangles.get(i);
                if (rectangle != null && rectangle.contains(containerPoint)) {
                    inButton = true;
                    this.testForDrag(eventID);
                }
                ++i;
            }
            if (inButton || this.inDrag) {
                Point componentPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, component);
                this.parentFrame.setCursor(Cursor.getDefaultCursor());
                component.dispatchEvent(new MouseEvent(component, eventID, e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
            } else {
                this.parentFrame.setCursor(Cursor.getPredefinedCursor(3));
            }
        }

        private void testForDrag(int eventID) {
            if (eventID == 501) {
                this.inDrag = true;
            }
        }
    }
}

