/*
 * Decompiled with CFR 0.152.
 */
package jmri.swing;

import com.alexandriasoftware.swing.JInputValidator;
import com.alexandriasoftware.swing.JInputValidatorPreferences;
import com.alexandriasoftware.swing.Validation;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import jmri.Manager;
import jmri.NamedBean;
import jmri.ProxyManager;
import jmri.swing.Bundle;

public class SystemNameValidator
extends JInputValidator {
    private Manager<?> manager;
    private boolean required = false;

    public SystemNameValidator(@Nonnull JComponent component, @Nonnull Manager<?> manager) {
        this(component, manager, false);
    }

    public SystemNameValidator(@Nonnull JComponent component, @Nonnull Manager<?> manager, boolean required) {
        super(component, true, required);
        this.setManager(manager);
        this.required = required;
    }

    protected Validation getValidation(JComponent component, JInputValidatorPreferences preferences) {
        JTextComponent jtc;
        String text;
        if (component instanceof JTextComponent && (text = (jtc = (JTextComponent)component).getText()) != null && !text.isEmpty()) {
            try {
                if (this.manager instanceof ProxyManager) {
                    ProxyManager proxyManager = (ProxyManager)this.manager;
                    proxyManager.validateSystemNameFormat(text);
                } else {
                    this.manager.makeSystemName(text, false);
                }
            }
            catch (NamedBean.BadSystemNameException ex) {
                if (this.manager.validSystemNameFormat(text) == Manager.NameValidity.VALID_AS_PREFIX_ONLY) {
                    return new Validation(Validation.Type.WARNING, Bundle.getMessage("SystemNameValidatorValidPrefix", text, this.manager.getBeanTypeHandled(), this.trimHtmlTags(this.getToolTipText())), preferences);
                }
                return new Validation(Validation.Type.DANGER, Bundle.getMessage("SystemNameValidatorInvalid", ex.getMessage(), this.trimHtmlTags(this.getToolTipText())), preferences);
            }
            return new Validation(Validation.Type.SUCCESS, this.getToolTipText(), preferences);
        }
        if (this.required) {
            return new Validation(Validation.Type.WARNING, Bundle.getMessage("SystemNameValidatorRequired", this.trimHtmlTags(this.getToolTipText())), preferences);
        }
        return this.getNoneValidation();
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setManager(@Nonnull Manager<?> manager) {
        Objects.requireNonNull(manager, "Cannot validate against a null manager");
        Manager<?> old = this.manager;
        if (old == null || !old.equals(manager)) {
            this.manager = manager;
            this.getPropertyChangeSupport().firePropertyChange("manager", old, this.manager);
            this.verify(this.getComponent());
        }
    }
}

