/*
 * Decompiled with CFR 0.152.
 */
package jmri.swing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableModel;

public final class RowSorterUtil {
    @Nonnull
    public static SortOrder getSortOrder(@Nonnull RowSorter<? extends TableModel> rowSorter, int column) {
        for (RowSorter.SortKey key : rowSorter.getSortKeys()) {
            if (key.getColumn() != column) continue;
            return key.getSortOrder();
        }
        return SortOrder.UNSORTED;
    }

    public static void setSortOrder(@Nonnull RowSorter<? extends TableModel> rowSorter, int column, @Nonnull SortOrder sortOrder) {
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
        if (!sortOrder.equals((Object)SortOrder.UNSORTED)) {
            keys.add(new RowSorter.SortKey(column, sortOrder));
        }
        rowSorter.setSortKeys(keys);
    }

    public static RowSorterListener addSingleSortableColumnListener(@Nonnull RowSorter<? extends TableModel> rowSorter) {
        Objects.requireNonNull(rowSorter, "rowSorter must be nonnull.");
        RowSorterListener listener = new RowSorterListener(){
            List<? extends RowSorter.SortKey> priorSortKeys = new ArrayList<RowSorter.SortKey>();

            @Override
            public void sorterChanged(RowSorterEvent e) {
                if (e.getType().equals((Object)RowSorterEvent.Type.SORT_ORDER_CHANGED)) {
                    Object source = e.getSource();
                    ArrayList<RowSorter.SortKey> newSortKeys = new ArrayList<RowSorter.SortKey>(((RowSorter)source).getSortKeys());
                    newSortKeys.removeAll(this.priorSortKeys);
                    if (!newSortKeys.isEmpty()) {
                        this.priorSortKeys = newSortKeys;
                        ((RowSorter)source).setSortKeys(this.priorSortKeys);
                        ((RowSorter)source).allRowsChanged();
                    }
                }
            }
        };
        rowSorter.addRowSorterListener(listener);
        return listener;
    }
}

