/*
 * Decompiled with CFR 0.152.
 */
package jmri.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import jmri.InstanceManager;
import jmri.PowerManager;
import jmri.swing.Bundle;

public abstract class PowerManagerMenu
extends JMenu {
    List<JMenuItem> items = new ArrayList<JMenuItem>();

    public PowerManager get() {
        return null;
    }

    protected abstract void choiceChanged();

    public PowerManagerMenu() {
        ButtonGroup group = new ButtonGroup();
        this.setText(Bundle.getMessage("MenuConnection"));
        List<PowerManager> managers = InstanceManager.getList(PowerManager.class);
        for (PowerManager mgr : managers) {
            if (mgr == null) continue;
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(mgr.getUserName());
            this.add(item);
            group.add(item);
            this.items.add(item);
            item.addActionListener(e -> this.choiceChanged());
        }
        this.setDefault();
    }

    void setDefault() {
        PowerManager manager = InstanceManager.getNullableDefault(PowerManager.class);
        if (manager == null) {
            return;
        }
        String defaultMgr = manager.getUserName();
        for (JMenuItem item : this.items) {
            if (!defaultMgr.equals(item.getActionCommand())) continue;
            item.setSelected(true);
        }
    }

    public PowerManager getManager() {
        PowerManager manager = InstanceManager.getNullableDefault(PowerManager.class);
        if (manager == null) {
            return null;
        }
        String name = manager.getUserName();
        for (JMenuItem item : this.items) {
            if (!item.isSelected()) continue;
            name = item.getActionCommand();
            break;
        }
        List<PowerManager> managers = InstanceManager.getList(PowerManager.class);
        for (PowerManager mgr : managers) {
            if (!name.equals(mgr.getUserName())) continue;
            return mgr;
        }
        return null;
    }
}

