/*
 * Decompiled with CFR 0.152.
 */
package jmri.swing;

import com.alexandriasoftware.swing.JInputValidator;
import com.alexandriasoftware.swing.JInputValidatorPreferences;
import com.alexandriasoftware.swing.Validation;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import jmri.Manager;
import jmri.NamedBean;
import jmri.ProvidingManager;
import jmri.beans.SwingPropertyChangeListener;
import jmri.swing.Bundle;
import jmri.util.NamedBeanComparator;
import jmri.util.NamedBeanUserNameComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedBeanComboBox<B extends NamedBean>
extends JComboBox<B> {
    private final transient Manager<B> manager;
    private NamedBean.DisplayOptions displayOptions;
    private boolean allowNull = false;
    private boolean providing = true;
    private boolean validatingInput = true;
    private final transient Set<B> excludedItems = new HashSet<B>();
    private final transient PropertyChangeListener managerListener = new SwingPropertyChangeListener(evt -> this.sort());
    private String userInput = null;
    private static final Logger log = LoggerFactory.getLogger(NamedBeanComboBox.class);

    public NamedBeanComboBox(Manager<B> manager) {
        this(manager, null);
    }

    public NamedBeanComboBox(Manager<B> manager, B selection) {
        this(manager, selection, NamedBean.DisplayOptions.DISPLAYNAME);
    }

    public NamedBeanComboBox(Manager<B> manager, B selection, NamedBean.DisplayOptions displayOrder) {
        this.manager = manager;
        super.setToolTipText(Bundle.getMessage("NamedBeanComboBoxDefaultToolTipText", this.manager.getBeanTypeHandled(true)));
        this.setDisplayOrder(displayOrder);
        this.setEditable(false);
        NamedBeanRenderer namedBeanRenderer = new NamedBeanRenderer(this.getRenderer());
        this.setRenderer(namedBeanRenderer);
        this.setKeySelectionManager(namedBeanRenderer);
        NamedBeanEditor namedBeanEditor = new NamedBeanEditor(this.getEditor());
        this.setEditor(namedBeanEditor);
        this.manager.addPropertyChangeListener("beans", this.managerListener);
        this.manager.addPropertyChangeListener("DisplayListName", this.managerListener);
        this.sort();
        this.setSelectedItem(selection);
    }

    public Manager<B> getManager() {
        return this.manager;
    }

    public NamedBean.DisplayOptions getDisplayOrder() {
        return this.displayOptions;
    }

    public final void setDisplayOrder(NamedBean.DisplayOptions displayOrder) {
        if (this.displayOptions != displayOrder) {
            this.displayOptions = displayOrder;
            this.sort();
        }
    }

    public boolean isValidatingInput() {
        return this.validatingInput;
    }

    public void setValidatingInput(boolean validatingInput) {
        this.validatingInput = validatingInput;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
        if (allowNull && this.getModel().getSize() > 0 && this.getItemAt(0) != null) {
            this.insertItemAt(null, 0);
        } else if (!allowNull && this.getModel().getSize() > 0 && this.getItemAt(0) == null) {
            this.removeItemAt(0);
        }
    }

    @Override
    public B getSelectedItem() {
        Component ec;
        NamedBean item = (NamedBean)this.getItemAt(this.getSelectedIndex());
        if (this.isEditable() && this.providing && item == null && (ec = this.getEditor().getEditorComponent()) instanceof JTextComponent && this.manager instanceof ProvidingManager) {
            JTextComponent jtc = (JTextComponent)ec;
            this.userInput = jtc.getText();
            if (this.userInput != null && !this.userInput.isEmpty() && (this.manager.isValidSystemNameFormat(this.userInput) || this.userInput.equals(NamedBean.normalizeUserName(this.userInput)))) {
                ProvidingManager pm = (ProvidingManager)this.manager;
                item = pm.provide(this.userInput);
                this.setSelectedItem(item);
            }
        }
        return (B)item;
    }

    public boolean isProviding() {
        return this.providing;
    }

    public void setProviding(boolean providing) {
        this.providing = providing;
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable && !(this.manager instanceof ProvidingManager)) {
            log.error("Unable to set editable to true because not backed by editable manager");
            return;
        }
        if (editable && !this.providing) {
            log.error("Refusing to set editable if not allowing new NamedBeans to be created");
            return;
        }
        super.setEditable(editable);
    }

    public String getSelectedItemDisplayName() {
        Object item = this.getSelectedItem();
        return item != null ? item.getDisplayName() : null;
    }

    public String getSelectedItemSystemName() {
        Object item = this.getSelectedItem();
        return item != null ? item.getSystemName() : null;
    }

    public String getSelectedItemUserName() {
        Object item = this.getSelectedItem();
        return item != null ? item.getUserName() : null;
    }

    @Override
    public void setSelectedItem(Object item) {
        super.setSelectedItem(item);
        if (this.getItemAt(this.getSelectedIndex()) != null) {
            this.userInput = null;
        }
    }

    public void setSelectedItemByName(String name) {
        Object item = null;
        if (name != null) {
            item = this.manager.getNamedBean(name);
        }
        if (item == null && !this.allowNull) {
            throw new IllegalArgumentException();
        }
        this.setSelectedItem(item);
    }

    public void dispose() {
        this.manager.removePropertyChangeListener("beans", this.managerListener);
        this.manager.removePropertyChangeListener("DisplayListName", this.managerListener);
    }

    private void sort() {
        NamedBean selectedItem = (NamedBean)this.getItemAt(this.getSelectedIndex());
        Comparator comparator = new NamedBeanComparator();
        if (this.displayOptions != NamedBean.DisplayOptions.SYSTEMNAME && this.displayOptions != NamedBean.DisplayOptions.QUOTED_SYSTEMNAME) {
            comparator = new NamedBeanUserNameComparator();
        }
        TreeSet set = new TreeSet(comparator);
        set.addAll(this.manager.getNamedBeanSet());
        set.removeAll(this.excludedItems);
        Vector vector = new Vector(set);
        if (this.allowNull) {
            vector.add(0, null);
        }
        this.setModel(new DefaultComboBoxModel(vector));
        if (selectedItem == null && this.userInput != null) {
            this.setSelectedItemByName(this.userInput);
        } else {
            this.setSelectedItem(selectedItem);
        }
    }

    public String getBeanInUseMessage(String beanType, String displayName) {
        return Bundle.getMessage("NamedBeanComboBoxBeanInUse", beanType, displayName);
    }

    public String getInvalidNameFormatMessage(String beanType, String text, String exception) {
        return Bundle.getMessage("NamedBeanComboBoxInvalidNameFormat", beanType, text, exception);
    }

    public String getNoMatchingBeanMessage(String beanType, String text) {
        return Bundle.getMessage("NamedBeanComboBoxNoMatchingBean", beanType, text);
    }

    public String getWillCreateBeanMessage(String beanType, String text) {
        return Bundle.getMessage("NamedBeanComboBoxWillCreateBean", beanType, text);
    }

    public Set<B> getExcludedItems() {
        return this.excludedItems;
    }

    public void setExcludedItems(Set<B> excludedItems) {
        this.excludedItems.clear();
        this.excludedItems.addAll(excludedItems);
        this.sort();
    }

    private class NamedBeanEditor
    implements ComboBoxEditor {
        private final ComboBoxEditor editor;

        public NamedBeanEditor(ComboBoxEditor editor) {
            this.editor = editor;
            Component ec = editor.getEditorComponent();
            if (ec instanceof JComponent) {
                JComponent jc = (JComponent)ec;
                jc.setInputVerifier((InputVerifier)new JInputValidator(jc, true, false){

                    protected Validation getValidation(JComponent component, JInputValidatorPreferences preferences) {
                        JTextComponent jtc;
                        String text;
                        if (component instanceof JTextComponent && (text = (jtc = (JTextComponent)component).getText()) != null && !text.isEmpty()) {
                            Object bean = NamedBeanComboBox.this.manager.getNamedBean(text);
                            if (bean != null) {
                                NamedBeanComboBox.this.setSelectedItem(bean);
                                if (!bean.equals(NamedBeanComboBox.this.getItemAt(NamedBeanComboBox.this.getSelectedIndex())) && NamedBeanComboBox.this.getSelectedIndex() != -1) {
                                    jtc.setText(text);
                                    if (NamedBeanComboBox.this.validatingInput) {
                                        return new Validation(Validation.Type.DANGER, NamedBeanComboBox.this.getBeanInUseMessage(NamedBeanComboBox.this.manager.getBeanTypeHandled(), bean.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME)), preferences);
                                    }
                                }
                            } else if (NamedBeanComboBox.this.validatingInput) {
                                if (NamedBeanComboBox.this.providing) {
                                    try {
                                        NamedBeanComboBox.this.manager.validateSystemNameFormat(text);
                                    }
                                    catch (IllegalArgumentException ex) {
                                        return new Validation(Validation.Type.DANGER, NamedBeanComboBox.this.getInvalidNameFormatMessage(NamedBeanComboBox.this.manager.getBeanTypeHandled(), text, ex.getLocalizedMessage()), preferences);
                                    }
                                    return new Validation(Validation.Type.INFORMATION, NamedBeanComboBox.this.getWillCreateBeanMessage(NamedBeanComboBox.this.manager.getBeanTypeHandled(), text), preferences);
                                }
                                return new Validation(Validation.Type.WARNING, NamedBeanComboBox.this.getNoMatchingBeanMessage(NamedBeanComboBox.this.manager.getBeanTypeHandled(), text), preferences);
                            }
                        }
                        return this.getNoneValidation();
                    }
                });
            }
        }

        @Override
        public Component getEditorComponent() {
            return this.editor.getEditorComponent();
        }

        @Override
        public void setItem(Object anObject) {
            Component c = this.getEditorComponent();
            if (c instanceof JTextComponent) {
                JTextComponent jtc = (JTextComponent)c;
                if (anObject instanceof NamedBean) {
                    NamedBean nb = (NamedBean)anObject;
                    jtc.setText(nb.getDisplayName(NamedBeanComboBox.this.displayOptions));
                } else {
                    jtc.setText("");
                }
            } else {
                this.editor.setItem(anObject);
            }
        }

        @Override
        public Object getItem() {
            return this.editor.getItem();
        }

        @Override
        public void selectAll() {
            this.editor.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.editor.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.editor.removeActionListener(l);
        }
    }

    private class NamedBeanRenderer
    implements ListCellRenderer<B>,
    JComboBox.KeySelectionManager {
        private final ListCellRenderer<? super B> renderer;
        private final long timeFactor;
        private long lastTime;
        private String prefix = "";

        public NamedBeanRenderer(ListCellRenderer<? super B> renderer) {
            this.renderer = renderer;
            Long l = (Long)UIManager.get("ComboBox.timeFactor");
            this.timeFactor = l != null ? l : 1000L;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends B> list, B value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                label.setText(value.getDisplayName(NamedBeanComboBox.this.displayOptions));
            }
            return label;
        }

        public int selectionForKey(char key, ComboBoxModel model) {
            int index;
            long time = System.currentTimeMillis();
            int size = model.getSize();
            int startIndex = -1;
            NamedBean selectedItem = (NamedBean)model.getSelectedItem();
            if (selectedItem != null) {
                int i = 0;
                while (i < size) {
                    if (selectedItem == model.getElementAt(i)) {
                        startIndex = i;
                        break;
                    }
                    ++i;
                }
            }
            if (time - this.lastTime < this.timeFactor) {
                if (this.prefix.length() == 1 && key == this.prefix.charAt(0)) {
                    ++startIndex;
                } else {
                    this.prefix = String.valueOf(this.prefix) + key;
                }
            } else {
                ++startIndex;
                this.prefix = "" + key;
            }
            this.lastTime = time;
            if (startIndex < 0 || startIndex >= size) {
                startIndex = 0;
            }
            if ((index = this.getNextMatch(this.prefix, startIndex, size, model)) < 0) {
                index = this.getNextMatch(this.prefix, 0, startIndex, model);
            }
            return index;
        }

        private int getNextMatch(String prefix, int start, int end, ComboBoxModel model) {
            int i = start;
            while (i < end) {
                NamedBean item = (NamedBean)model.getElementAt(i);
                if (item != null) {
                    String userName = item.getUserName();
                    if (item.getSystemName().toLowerCase().startsWith(prefix) || userName != null && userName.toLowerCase().startsWith(prefix)) {
                        return i;
                    }
                }
                ++i;
            }
            return -1;
        }
    }
}

