/*
 * Decompiled with CFR 0.152.
 */
package jmri.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jmri.Manager;
import jmri.NamedBean;
import jmri.ProxyManager;

public class ManagerComboBox<B extends NamedBean>
extends JComboBox<Manager<B>> {
    public ManagerComboBox() {
        this(new ArrayList<Manager<B>>());
    }

    public ManagerComboBox(@Nonnull List<Manager<B>> list) {
        this(list, null);
    }

    public ManagerComboBox(@Nonnull List<Manager<B>> list, Manager<B> selection) {
        this.setRenderer(new ManagerRenderer(this.getRenderer()));
        this.setManagers(list, selection);
    }

    public void setManagers(@Nonnull List<Manager<B>> list) {
        this.setManagers(list, null);
    }

    public void setManagers(@Nonnull List<Manager<B>> list, Manager<B> selection) {
        this.setModel(new DefaultComboBoxModel<Manager<B>>(new Vector<Manager<B>>(list)));
        if (!list.isEmpty()) {
            if (selection == null) {
                this.setSelectedIndex(0);
            } else {
                this.setSelectedItem(selection);
            }
        }
    }

    public void setManagers(@Nonnull Manager<B> manager) {
        if (manager instanceof ProxyManager) {
            ProxyManager proxy = (ProxyManager)manager;
            this.setManagers(proxy.getDisplayOrderManagerList(), proxy.getDefaultManager());
        } else {
            ArrayList<Manager<B>> list = new ArrayList<Manager<B>>();
            list.add(manager);
            this.setManagers(list, manager);
        }
    }

    @Override
    public Manager<B> getSelectedItem() {
        return (Manager)this.getItemAt(this.getSelectedIndex());
    }

    private class ManagerRenderer
    implements ListCellRenderer<Manager<B>> {
        private final ListCellRenderer<? super Manager<B>> renderer;

        public ManagerRenderer(ListCellRenderer<? super Manager<B>> renderer) {
            this.renderer = renderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Manager<B>> list, Manager<B> value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                label.setText(value.getMemo().getUserName());
            }
            return label;
        }
    }
}

