/*
 * Decompiled with CFR 0.152.
 */
package jmri.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;
import jmri.swing.JTablePersistenceManager;
import jmri.swing.RowSorterUtil;
import jmri.util.TimerUtil;
import jmri.util.jdom.JDOMUtil;
import jmri.util.prefs.AbstractPreferencesManager;
import jmri.util.prefs.InitializationException;
import jmri.util.swing.XTableColumnModel;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriJTablePersistenceManager
extends AbstractPreferencesManager
implements JTablePersistenceManager,
PropertyChangeListener {
    protected final HashMap<String, JTableListener> listeners = new HashMap();
    protected final HashMap<String, HashMap<String, TableColumnPreferences>> columns = new HashMap();
    protected final HashMap<String, List<RowSorter.SortKey>> sortKeys = new HashMap();
    private boolean paused = false;
    private boolean dirty = false;
    public final String PAUSED = "paused";
    public static final String TABLES_NAMESPACE = "http://jmri.org/xml/schema/auxiliary-configuration/table-details-4-3-5.xsd";
    public static final String TABLES_ELEMENT = "tableDetails";
    public static final String SORT_ORDER = "sortOrder";
    private static final Logger log = LoggerFactory.getLogger(JmriJTablePersistenceManager.class);

    @Override
    public void persist(@Nonnull JTable table, boolean resetState) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(table.getName(), "Table name must be nonnull");
        if (this.listeners.containsKey(table.getName()) && !this.listeners.get(table.getName()).getTable().equals(table)) {
            throw new IllegalArgumentException("Table name " + table.getName() + " must be unique");
        }
        if (resetState) {
            this.resetState(table);
        }
        if (!this.listeners.containsKey(table.getName())) {
            JTableListener listener = new JTableListener(table, this);
            this.listeners.put(table.getName(), listener);
            if (!Arrays.asList(table.getPropertyChangeListeners()).contains(this)) {
                table.addPropertyChangeListener(this);
                table.addPropertyChangeListener(listener);
                TableColumnModel model = table.getColumnModel();
                model.addColumnModelListener(listener);
                RowSorter<? extends TableModel> sorter = table.getRowSorter();
                if (sorter != null) {
                    sorter.addRowSorterListener(listener);
                }
                Enumeration<TableColumn> e = this.getColumns(model);
                ArrayList<Object> columnIds = new ArrayList<Object>();
                while (e.hasMoreElements()) {
                    TableColumn column = e.nextElement();
                    column.addPropertyChangeListener(listener);
                    Object columnId = column.getIdentifier();
                    if (columnId == null || columnId.toString().isEmpty()) {
                        log.error("Columns in table {} have empty or null identities; saving table state will not be reliable.", (Object)table.getName());
                        continue;
                    }
                    if (columnIds.contains(columnId)) {
                        log.error("Columns in table {} share the identity \"{}\"; saving table state will not be reliable.", (Object)table.getName(), columnId);
                        continue;
                    }
                    columnIds.add(columnId);
                }
                if (log.isDebugEnabled() && this.getColumnCount(model) != columnIds.size()) {
                    log.debug("Saving table state for table {} will not be reliable.", (Object)table.getName(), (Object)new Exception());
                }
            }
        }
        if (this.columns.get(table.getName()) == null) {
            this.cacheState(table);
        }
    }

    @Override
    public void stopPersisting(JTable table) {
        Objects.requireNonNull(table.getName(), "table name must be nonnull");
        JTableListener listener = this.listeners.remove(table.getName());
        table.removePropertyChangeListener(this);
        table.removePropertyChangeListener(listener);
        table.getColumnModel().removeColumnModelListener(listener);
        RowSorter<? extends TableModel> sorter = table.getRowSorter();
        if (sorter != null) {
            sorter.removeRowSorterListener(listener);
        }
        Enumeration<TableColumn> e = this.getColumns(table.getColumnModel());
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            column.removePropertyChangeListener(listener);
        }
    }

    @Override
    public void clearState(JTable table) {
        Objects.requireNonNull(table.getName(), "table name must be nonnull");
        this.columns.remove(table.getName());
        this.dirty = true;
    }

    @Override
    public void cacheState(JTable table) {
        Objects.requireNonNull(table.getName(), "table name must be nonnull");
        TableColumnModel model = table.getColumnModel();
        Objects.requireNonNull(model, "table " + table.getName() + " has a null columnModel");
        RowSorter<? extends TableModel> sorter = table.getRowSorter();
        boolean isXModel = model instanceof XTableColumnModel;
        Enumeration<TableColumn> e = this.getColumns(table.getColumnModel());
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            String name = column.getIdentifier().toString();
            int index = column.getModelIndex();
            if (isXModel) {
                index = ((XTableColumnModel)model).getColumnIndex(column.getIdentifier(), false);
            }
            int width = column.getPreferredWidth();
            boolean hidden = false;
            if (isXModel) {
                hidden = !((XTableColumnModel)model).isColumnVisible(column);
            }
            SortOrder sorted = SortOrder.UNSORTED;
            if (sorter != null) {
                sorted = RowSorterUtil.getSortOrder(sorter, index);
                log.trace("Column {} (model index {}) is {}", new Object[]{name, index, sorted});
            }
            this.setPersistedState(table.getName(), name, index, width, sorted, hidden);
        }
        if (sorter != null) {
            this.sortKeys.put(table.getName(), new ArrayList<RowSorter.SortKey>(sorter.getSortKeys()));
        }
        this.dirty = true;
    }

    @Override
    public void resetState(JTable table) {
        Objects.requireNonNull(table.getName(), "table name must be nonnull");
        boolean persisting = this.listeners.containsKey(table.getName());
        this.stopPersisting(table);
        TableColumnModel model = table.getColumnModel();
        Objects.requireNonNull(model, "table " + table.getName() + " has a null columnModel");
        RowSorter<? extends TableModel> sorter = table.getRowSorter();
        boolean isXModel = model instanceof XTableColumnModel;
        HashMap indexes = new HashMap();
        if (this.columns.get(table.getName()) == null) {
            this.columns.put(table.getName(), new HashMap());
        }
        this.columns.get(table.getName()).entrySet().stream().forEach(entry -> {
            int index = ((TableColumnPreferences)entry.getValue()).getOrder();
            indexes.put(index, (String)entry.getKey());
        });
        int count = this.getColumnCount(model);
        if (indexes.size() == count) {
            int i = 0;
            while (i < count) {
                String name = (String)indexes.get(i);
                if (name != null) {
                    int dataModelIndex = -1;
                    int j = 0;
                    while (j < count) {
                        Object identifier = (isXModel ? ((XTableColumnModel)model).getColumn(j, false) : model.getColumn(j)).getIdentifier();
                        if (identifier != null && identifier.equals(name)) {
                            dataModelIndex = j;
                            break;
                        }
                        ++j;
                    }
                    if (dataModelIndex != -1 && dataModelIndex != i) {
                        if (isXModel) {
                            ((XTableColumnModel)model).moveColumn(dataModelIndex, i, false);
                        } else {
                            model.moveColumn(dataModelIndex, i);
                        }
                    }
                }
                ++i;
            }
        }
        Enumeration<TableColumn> e = this.getColumns(table.getColumnModel());
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            String name = column.getIdentifier().toString();
            TableColumnPreferences preferences = this.columns.get(table.getName()).get(name);
            if (preferences == null) continue;
            column.setPreferredWidth(preferences.getPreferredWidth());
            if (!isXModel) continue;
            ((XTableColumnModel)model).setColumnVisible(column, !preferences.getHidden());
        }
        if (sorter != null && this.sortKeys.get(table.getName()) != null) {
            try {
                sorter.setSortKeys(this.sortKeys.get(table.getName()));
            }
            catch (IllegalArgumentException ex) {
                log.debug("Ignoring IllegalArgumentException \"{}\" as column does not exist.", (Object)ex.getMessage());
            }
        }
        if (persisting) {
            this.persist(table);
        }
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setPaused(boolean paused) {
        Profile profile;
        boolean old = this.paused;
        this.paused = paused;
        if (paused != old) {
            this.firePropertyChange("paused", old, paused);
        }
        if (!paused && this.dirty && (profile = ProfileManager.getDefault().getActiveProfile()) != null) {
            this.savePreferences(profile);
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void initialize(Profile profile) throws InitializationException {
        try {
            Element element = JDOMUtil.toJDOMElement(ProfileUtils.getUserInterfaceConfiguration(ProfileManager.getDefault().getActiveProfile()).getConfigurationFragment(TABLES_ELEMENT, TABLES_NAMESPACE, false));
            element.getChildren("table").stream().forEach(table -> {
                String tableName = table.getAttributeValue("name");
                int sortColumn = -1;
                SortOrder sortOrder = SortOrder.UNSORTED;
                Element sortElement = table.getChild(SORT_ORDER);
                if (sortElement != null) {
                    ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
                    for (Element sortKey : sortElement.getChildren()) {
                        sortOrder = SortOrder.valueOf(sortKey.getAttributeValue(SORT_ORDER));
                        try {
                            sortColumn = sortKey.getAttribute("column").getIntValue();
                            RowSorter.SortKey key = new RowSorter.SortKey(sortColumn, sortOrder);
                            keys.add(key);
                        }
                        catch (DataConversionException dataConversionException) {
                            log.error("Unable to get sort column as integer");
                        }
                    }
                    this.sortKeys.put(tableName, keys);
                }
                log.debug("Table {} column {} is sorted {}", new Object[]{tableName, sortColumn, sortOrder});
                for (Element column : table.getChild("columns").getChildren()) {
                    boolean hidden;
                    int width;
                    int order;
                    String columnName;
                    block10: {
                        columnName = column.getAttribute("name").getValue();
                        order = -1;
                        width = -1;
                        hidden = false;
                        try {
                            if (column.getAttributeValue("order") != null) {
                                order = column.getAttribute("order").getIntValue();
                            }
                            if (column.getAttributeValue("width") != null) {
                                width = column.getAttribute("width").getIntValue();
                            }
                            if (column.getAttribute("hidden") == null) break block10;
                            hidden = column.getAttribute("hidden").getBooleanValue();
                        }
                        catch (DataConversionException dataConversionException) {
                            log.error("Unable to parse column \"{}\"", (Object)columnName);
                            continue;
                        }
                    }
                    if (sortColumn == order) {
                        this.setPersistedState(tableName, columnName, order, width, sortOrder, hidden);
                        continue;
                    }
                    this.setPersistedState(tableName, columnName, order, width, SortOrder.UNSORTED, hidden);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            log.info("Table preferences not found.\nThis is expected on the first time the \"{}\" profile is used on this computer.", (Object)ProfileManager.getDefault().getActiveProfileName());
        }
        this.setInitialized(profile, true);
    }

    @Override
    public synchronized void savePreferences(Profile profile) {
        log.debug("Saving preferences (dirty={})...", (Object)this.dirty);
        Element element = new Element(TABLES_ELEMENT, TABLES_NAMESPACE);
        if (!this.columns.isEmpty()) {
            this.columns.entrySet().stream().map(entry -> {
                Element table = new Element("table").setAttribute("name", (String)entry.getKey());
                Element columnsElement = new Element("columns");
                ((HashMap)entry.getValue()).entrySet().stream().map(column -> {
                    Element columnElement = new Element("column").setAttribute("name", (String)column.getKey());
                    if (((TableColumnPreferences)column.getValue()).getOrder() != -1) {
                        columnElement.setAttribute("order", Integer.toString(((TableColumnPreferences)column.getValue()).getOrder()));
                    }
                    if (((TableColumnPreferences)column.getValue()).getPreferredWidth() != -1) {
                        columnElement.setAttribute("width", Integer.toString(((TableColumnPreferences)column.getValue()).getPreferredWidth()));
                    }
                    columnElement.setAttribute("hidden", Boolean.toString(((TableColumnPreferences)column.getValue()).getHidden()));
                    return columnElement;
                }).forEach(columnElement -> columnsElement.addContent((Content)columnElement));
                table.addContent((Content)columnsElement);
                List<RowSorter.SortKey> keys = this.sortKeys.get(entry.getKey());
                if (keys != null) {
                    Element sorter = new Element(SORT_ORDER);
                    keys.stream().forEach(key -> sorter.addContent((Content)new Element("sortKey").setAttribute("column", Integer.toString(key.getColumn())).setAttribute(SORT_ORDER, key.getSortOrder().name())));
                    table.addContent((Content)sorter);
                }
                return table;
            }).forEach(table -> element.addContent((Content)table));
        }
        try {
            ProfileUtils.getUserInterfaceConfiguration(ProfileManager.getDefault().getActiveProfile()).putConfigurationFragment(JDOMUtil.toW3CElement(element), false);
        }
        catch (JDOMException ex) {
            log.error("Unable to save user preferences", (Throwable)ex);
        }
        this.dirty = false;
    }

    @Override
    @Nonnull
    public Set<Class<?>> getProvides() {
        Iterable provides = super.getProvides();
        provides.add(JTablePersistenceManager.class);
        return provides;
    }

    @Deprecated
    public void setTableColumnPreferences(String table, String column, int order, int width, SortOrder sort, boolean hidden) {
        Objects.requireNonNull(table, "table name must be nonnull");
        if (sort != SortOrder.UNSORTED) {
            ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
            keys.add(new RowSorter.SortKey(order, sort));
            this.sortKeys.put(table, keys);
        }
        this.setPersistedState(table, column, order, width, sort, hidden);
    }

    protected void setPersistedState(@Nonnull String table, @Nonnull String column, int order, int width, SortOrder sort, boolean hidden) {
        Objects.requireNonNull(table, "table name must be nonnull");
        Objects.requireNonNull(column, "column name must be nonnull");
        if (!this.columns.containsKey(table)) {
            this.columns.put(table, new HashMap());
        }
        HashMap<String, TableColumnPreferences> columnPrefs = this.columns.get(table);
        columnPrefs.put(column, new TableColumnPreferences(order, width, sort, hidden));
        this.dirty = true;
    }

    @Override
    public boolean isPersistenceDataRetained(JTable table) {
        Objects.requireNonNull(table, "Table must be non-null");
        return this.isPersistenceDataRetained(table.getName());
    }

    @Override
    public boolean isPersistenceDataRetained(String name) {
        Objects.requireNonNull(name, "Table name must be non-null");
        return this.columns.containsKey(name);
    }

    @Override
    public boolean isPersisting(JTable table) {
        Objects.requireNonNull(table, "Table must be non-null");
        return this.isPersisting(table.getName());
    }

    @Override
    public boolean isPersisting(String name) {
        Objects.requireNonNull(name, "Table name must be non-null");
        return this.listeners.containsKey(name);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("name")) {
            String oldName = (String)evt.getOldValue();
            String newName = (String)evt.getNewValue();
            if (oldName != null && !this.listeners.containsKey(newName)) {
                if (newName != null) {
                    this.listeners.put(newName, this.listeners.get(oldName));
                    this.columns.put(newName, this.columns.get(oldName));
                } else {
                    this.stopPersisting((JTable)evt.getSource());
                }
                this.listeners.remove(oldName);
                this.columns.remove(oldName);
                this.dirty = true;
            }
        }
    }

    private Enumeration<TableColumn> getColumns(@Nonnull TableColumnModel model) {
        if (model instanceof XTableColumnModel) {
            return ((XTableColumnModel)model).getColumns(false);
        }
        return model.getColumns();
    }

    private int getColumnCount(@Nonnull TableColumnModel model) {
        if (model instanceof XTableColumnModel) {
            return ((XTableColumnModel)model).getColumnCount(false);
        }
        return model.getColumnCount();
    }

    protected static final class JTableListener
    implements PropertyChangeListener,
    RowSorterListener,
    TableColumnModelListener {
        private final JTable table;
        private final JmriJTablePersistenceManager manager;
        private TimerTask delay;

        public JTableListener(JTable table, JmriJTablePersistenceManager manager) {
            this.table = table;
            this.manager = manager;
        }

        private JTable getTable() {
            return this.table;
        }

        /*
         * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!(evt.getSource() instanceof JTable)) ** GOTO lbl33
            var2_2 = evt.getPropertyName();
            tmp = -1;
            switch (var2_2.hashCode()) {
                case -973829677: {
                    if (!var2_2.equals("ancestor")) break;
                    tmp = 1;
                    ** break;
                }
                case -563689022: {
                    if (!var2_2.equals("JComponent_TRANSFER_HANDLER")) break;
                    tmp = 1;
                    ** break;
                }
                case 3373707: {
                    if (!var2_2.equals("name")) break;
                    tmp = 1;
                    ** break;
                }
                case 550189039: {
                    if (!var2_2.equals("selectionForeground")) break;
                    tmp = 1;
                    ** break;
                }
                case 1103547079: {
                    if (!var2_2.equals("Frame.active")) break;
                    tmp = 1;
                    ** break;
                }
                case 1528505306: {
                    if (!var2_2.equals("selectionBackground")) break;
                    tmp = 1;
                    ** break;
                }
                case 2146666719: {
                    if (!var2_2.equals("transferHandler")) ** break;
                    tmp = 1;
                    ** break;
                }
lbl33:
                // 1 sources

                if (evt.getSource() instanceof TableColumn == false) return;
                column = (TableColumn)evt.getSource();
                name = column.getIdentifier().toString();
                var5_5 = evt.getPropertyName();
                tmp = -1;
                switch (var5_5.hashCode()) {
                    case -1681598011: {
                        if (!var5_5.equals("preferredWidth")) break;
                        tmp = 1;
                        break;
                    }
                    case 113126854: {
                        if (!var5_5.equals("width")) break;
                        tmp = 2;
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        this.saveState();
                        return;
                    }
                    default: {
                        JmriJTablePersistenceManager.access$1().trace("Got propertyChange {} for column {} (\"{}\" -> \"{}\")", new Object[]{evt.getPropertyName(), name, evt.getOldValue(), evt.getNewValue()});
                        return;
                    }
                    case 2: {
                        return;
                    }
                }
lbl57:
                // 9 sources

            }
            switch (tmp) {
                default: {
                    JmriJTablePersistenceManager.access$1().trace("Got propertyChange {} for table {} (\"{}\" -> \"{}\")", new Object[]{evt.getPropertyName(), this.table.getName(), evt.getOldValue(), evt.getNewValue()});
                    return;
                }
                case 1: 
            }
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            if (e.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                this.saveState();
                log.debug("Sort order changed for {}", (Object)this.table.getName());
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            this.saveState();
            log.debug("Got columnAdded for {} ({} -> {})", new Object[]{this.table.getName(), e.getFromIndex(), e.getToIndex()});
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            this.manager.clearState(this.table);
            this.saveState();
            log.debug("Got columnRemoved for {} ({} -> {})", new Object[]{this.table.getName(), e.getFromIndex(), e.getToIndex()});
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            if (e.getFromIndex() != e.getToIndex()) {
                this.saveState();
                log.debug("Got columnMoved for {} ({} -> {})", new Object[]{this.table.getName(), e.getFromIndex(), e.getToIndex()});
            }
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            log.trace("Got columnMarginChanged for {}", (Object)this.table.getName());
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
            log.trace("Got columnSelectionChanged for {} ({} -> {})", new Object[]{this.table.getName(), e.getFirstIndex(), e.getLastIndex()});
        }

        protected void cancelDelay() {
            if (this.delay != null) {
                this.delay.cancel();
                this.delay = null;
            }
        }

        private void saveState() {
            this.cancelDelay();
            this.delay = new TimerTask(){

                @Override
                public void run() {
                    manager.cacheState(table);
                    if (!manager.isPaused() && manager.isDirty()) {
                        manager.savePreferences(ProfileManager.getDefault().getActiveProfile());
                    }
                    this.cancelDelay();
                }
            };
            TimerUtil.schedule(this.delay, 500L);
        }
    }

    public static final class TableColumnPreferences {
        private final int order;
        private final int preferredWidth;
        private final SortOrder sort;
        private final boolean hidden;

        public TableColumnPreferences(int order, int preferredWidth, SortOrder sort, boolean hidden) {
            this.order = order;
            this.preferredWidth = preferredWidth;
            this.sort = sort;
            this.hidden = hidden;
        }

        public int getOrder() {
            return this.order;
        }

        public int getPreferredWidth() {
            return this.preferredWidth;
        }

        public SortOrder getSort() {
            return this.sort;
        }

        public boolean getHidden() {
            return this.hidden;
        }
    }
}

