/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.web.app;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.server.web.app.Bundle;
import jmri.server.web.spi.WebMenuItem;

public class JsonMenuItem
implements WebMenuItem {
    public String path;
    public String href = null;
    public String iconClass = null;
    public String title = null;
    public int position = 300;
    public boolean separatedBefore = false;
    public boolean separatedAfter = false;
    public boolean dynamic = false;

    public JsonMenuItem(@Nonnull JsonNode node) throws IllegalArgumentException {
        Objects.requireNonNull(node, "cannot parse null object");
        this.path = node.path("path").asText(null);
        if (this.path == null) {
            throw new IllegalArgumentException("path not specified");
        }
        this.href = node.path("href").asText(this.href);
        this.iconClass = node.path("iconClass").asText(this.iconClass);
        this.title = node.path("title").asText(this.title);
        this.position = node.path("position").asInt(this.position);
        this.separatedBefore = node.path("separatedBefore").asBoolean(this.separatedBefore);
        this.separatedAfter = node.path("separatedAfter").asBoolean(this.separatedAfter);
        this.dynamic = node.path("dynamic").asBoolean(this.dynamic);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public String getIconClass() {
        return this.iconClass;
    }

    @Override
    public String getTitle(Locale locale) {
        if (this.title == null) {
            return Bundle.getMessage(locale, this.getPath());
        }
        return this.title;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean isSeparatedBefore() {
        return this.separatedBefore;
    }

    @Override
    public boolean isSeparatedAfter() {
        return this.separatedAfter;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }
}

