/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.Nonnull;
import jmri.server.web.AbstractWebServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultWebServerConfiguration
extends AbstractWebServerConfiguration {
    private final HashMap<String, String> redirections = new HashMap();
    private final HashMap<String, String> files = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(DefaultWebServerConfiguration.class);

    public DefaultWebServerConfiguration() {
        this.loadMap(this.files, "FilePaths.properties");
        this.loadMap(this.redirections, "Redirections.properties");
    }

    @Nonnull
    public HashMap<String, String> getFilePaths() {
        return this.files;
    }

    @Nonnull
    public HashMap<String, String> getRedirectedPaths() {
        return this.redirections;
    }

    private void loadMap(@Nonnull HashMap<String, String> map, @Nonnull String resource) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream in = this.getClass().getResourceAsStream(resource);){
                Properties properties = new Properties();
                properties.load(in);
                properties.stringPropertyNames().forEach(path -> {
                    String string = map.put((String)path, properties.getProperty((String)path));
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | IllegalArgumentException | NullPointerException ex) {
            log.error("Unable to load {}", (Object)resource, (Object)ex);
        }
    }
}

