/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.util.JsonUtilHttpService;
import jmri.web.server.WebServerPreferences;

public class JsonUtilSocketService
extends JsonSocketService<JsonUtilHttpService> {
    private PropertyChangeListener rrNameListener;

    public JsonUtilSocketService(JsonConnection connection) {
        super(connection, new JsonUtilHttpService(connection.getObjectMapper()));
    }

    JsonUtilSocketService(JsonConnection connection, JsonUtilHttpService service) {
        super(connection, service);
    }

    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        String name = data.path("name").asText();
        switch (type) {
            case "ping": {
                this.connection.sendMessage((JsonNode)this.connection.getObjectMapper().createObjectNode().put("type", "pong"), request.id);
                break;
            }
            case "goodbye": {
                this.connection.sendMessage((JsonNode)this.connection.getObjectMapper().createObjectNode().put("type", "goodbye"), request.id);
                break;
            }
            case "railroad": {
                this.connection.sendMessage(((JsonUtilHttpService)this.service).doGet(type, name, data, request), request.id);
                this.rrNameListener = evt -> {
                    try {
                        this.handleRailroadChange();
                    }
                    catch (IOException iOException) {
                        InstanceManager.getDefault(WebServerPreferences.class).removePropertyChangeListener(this.rrNameListener);
                    }
                };
                InstanceManager.getOptionalDefault(WebServerPreferences.class).ifPresent(preferences -> preferences.addPropertyChangeListener(this.rrNameListener));
                break;
            }
            default: {
                this.connection.sendMessage(((JsonUtilHttpService)this.service).doPost(type, name, data, request), request.id);
            }
            case "locale": 
        }
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        this.connection.sendMessage((JsonNode)((JsonUtilHttpService)this.service).doGetList(type, data, request), request.id);
    }

    @Override
    public void onClose() {
        InstanceManager.getOptionalDefault(WebServerPreferences.class).ifPresent(preferences -> preferences.removePropertyChangeListener(this.rrNameListener));
    }

    private void handleRailroadChange() throws IOException {
        try {
            this.connection.sendMessage(((JsonUtilHttpService)this.service).doGet("railroad", null, (JsonNode)this.connection.getObjectMapper().createObjectNode(), new JsonRequest(this.connection.getLocale(), "v5", "get", 0)), 0);
        }
        catch (JsonException ex) {
            this.connection.sendMessage(ex.getJsonMessage(), 0);
        }
    }
}

