/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.turnout;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.ProvidingManager;
import jmri.Sensor;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.sensor.JsonSensorHttpService;
import jmri.server.json.turnout.Bundle;

public class JsonTurnoutHttpService
extends JsonNamedBeanHttpService<Turnout> {
    private final JsonSensorHttpService sensorService;

    public JsonTurnoutHttpService(ObjectMapper mapper) {
        super(mapper);
        this.sensorService = new JsonSensorHttpService(mapper);
    }

    @Override
    public ObjectNode doGet(Turnout turnout, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = this.getNamedBean(turnout, name, this.getType(), request);
        ObjectNode data = root.with("data");
        if (turnout != null) {
            data.put("inverted", turnout.getInverted());
            switch (turnout.getKnownState()) {
                case 4: {
                    data.put("state", 4);
                    break;
                }
                case 2: {
                    data.put("state", 2);
                    break;
                }
                case 8: {
                    data.put("state", 8);
                    break;
                }
                default: {
                    data.put("state", 0);
                }
            }
            data.put("feedbackMode", turnout.getFeedbackMode());
            ArrayNode modes = data.arrayNode();
            turnout.getValidFeedbackModes().forEach(arg_0 -> ((ArrayNode)modes).add(arg_0));
            data.set("feedbackModes", (JsonNode)modes);
            ArrayNode sensors = data.arrayNode();
            Sensor sensor = turnout.getFirstSensor();
            sensors.add(sensor == null ? null : this.sensorService.doGet(sensor, sensor.getSystemName(), "sensor", request));
            sensor = turnout.getSecondSensor();
            sensors.add(sensor == null ? null : this.sensorService.doGet(sensor, sensor.getSystemName(), "sensor", request));
            data.set("sensor", (JsonNode)sensors);
        }
        return root;
    }

    @Override
    public ObjectNode doPost(Turnout turnout, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        if (data.path("sensor").isArray()) {
            int number = 0;
            for (JsonNode node : data.path("sensor")) {
                if (node != null) {
                    this.addSensorToTurnout(turnout, node, number, request);
                }
                ++number;
            }
        }
        if (data.path("feedbackMode").isInt()) {
            try {
                turnout.setFeedbackMode(data.path("feedbackMode").asInt());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorInvalidProperty", "feedbackMode", type, name), request.id);
            }
        }
        if (data.path("inverted").isBoolean()) {
            turnout.setInverted(data.path("inverted").asBoolean());
        }
        turnout.setInverted(data.path("inverted").asBoolean(turnout.getInverted()));
        int state = data.path("state").asInt(0);
        switch (state) {
            case 4: {
                turnout.setCommandedState(4);
                break;
            }
            case 2: {
                turnout.setCommandedState(2);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorUnknownState", "turnout", state), request.id);
            }
        }
        return this.doGet(turnout, name, type, request);
    }

    private void addSensorToTurnout(@Nonnull Turnout turnout, @Nonnull JsonNode data, int number, @Nonnull JsonRequest request) throws JsonException {
        block8: {
            try {
                if (data.isNull()) {
                    turnout.provideFeedbackSensor(null, number);
                    break block8;
                }
                Sensor sensor = null;
                if (data.isTextual()) {
                    sensor = (Sensor)this.sensorService.getNamedBean("sensor", data.asText(), this.mapper.nullNode(), request);
                } else if (data.isObject()) {
                    sensor = (Sensor)this.sensorService.getNamedBean("sensor", data.path("name").asText(), data, request);
                } else {
                    throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorInvalidProperty", "sensor", "turnout", turnout.getSystemName()), request.id);
                }
                if (sensor != null) {
                    turnout.provideFeedbackSensor(sensor.getSystemName(), number);
                    break block8;
                }
                throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", "sensor", data.asText()), request.id);
            }
            catch (JmriException jmriException) {
                throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorInternal", "turnout"), request.id);
            }
        }
    }

    @Override
    protected void doDelete(Turnout bean, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        this.deleteBean(bean, name, type, data, request);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "turnout": 
            case "turnouts": {
                return this.doSchema(type, server, "jmri/server/json/turnout/turnout-server.json", "jmri/server/json/turnout/turnout-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    protected String getType() {
        return "turnout";
    }

    @Override
    protected ProvidingManager<Turnout> getManager() {
        return InstanceManager.getDefault(TurnoutManager.class);
    }
}

