/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.time;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.TimebaseRateException;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.time.Bundle;

public class JsonTimeHttpService
extends JsonHttpService {
    public JsonTimeHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public JsonNode doGet(String type, @CheckForNull String name, JsonNode data, JsonRequest request) throws JsonException {
        Timebase timebase = InstanceManager.getDefault(Timebase.class);
        return this.doGet(timebase, timebase.getTime(), request.id);
    }

    public JsonNode doGet(@Nonnull Timebase timebase, @Nonnull Date date, int id) {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("time", new StdDateFormat().format(date));
        data.put("rate", timebase.getRate());
        data.put("state", timebase.getRun() ? 2 : 4);
        return this.message("time", (JsonNode)data, id);
    }

    @Override
    public JsonNode doPost(String type, @CheckForNull String name, JsonNode data, JsonRequest request) throws JsonException {
        Timebase timebase = InstanceManager.getDefault(Timebase.class);
        try {
            int state;
            if (data.path("time").isTextual()) {
                timebase.setTime(new StdDateFormat().parse(data.path("time").asText()));
            }
            if (data.path("rate").isDouble() || data.path("rate").isInt()) {
                timebase.userSetRate(data.path("rate").asDouble());
            }
            if ((state = data.path("state").asInt(0)) == 2 || state == 4) {
                timebase.setRun(state == 2);
            }
        }
        catch (ParseException parseException) {
            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorTimeFormat"), request.id);
        }
        catch (TimebaseRateException timebaseRateException) {
            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorRateFactor"), request.id);
        }
        return this.doGet(type, name, data, request);
    }

    @Override
    public JsonNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        ArrayNode array = this.mapper.createArrayNode();
        array.add(this.doGet(type, null, data, request));
        return this.message(array, request.id);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        if ("time".equals(type)) {
            return this.doSchema(type, server, "jmri/server/json/time/time-server.json", "jmri/server/json/time/time-client.json", request.id);
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }
}

