/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.throttle;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.throttle.Bundle;

public class JsonThrottleHttpService
extends JsonHttpService {
    public JsonThrottleHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public JsonNode doGet(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "GetNotAllowed", type), request.id);
    }

    @Override
    public JsonNode doPost(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "PostNotAllowed", type), request.id);
    }

    public ArrayNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(400, Bundle.getMessage(request.locale, "UnlistableService", type), request.id);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        if ("throttle".equals(type)) {
            return this.doSchema(type, server, "jmri/server/json/throttle/throttle-server.json", "jmri/server/json/throttle/throttle-client.json", request.id);
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }
}

