/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.signalhead;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.signalhead.JsonSignalHeadHttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSignalHeadSocketService
extends JsonSocketService<JsonSignalHeadHttpService> {
    private final HashMap<String, SignalHeadListener> beanListeners = new HashMap();
    private SignalHeadsListener managerListener = null;
    private static final Logger log = LoggerFactory.getLogger(JsonSignalHeadSocketService.class);

    public JsonSignalHeadSocketService(JsonConnection connection) {
        this(connection, new JsonSignalHeadHttpService(connection.getObjectMapper()));
    }

    public JsonSignalHeadSocketService(JsonConnection connection, JsonSignalHeadHttpService service) {
        super(connection, service);
    }

    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        SignalHead signalHead;
        String name = data.path("name").asText();
        if (request.method.equals("put")) {
            this.connection.sendMessage(((JsonSignalHeadHttpService)this.service).doPut(type, name, data, request), request.id);
        } else {
            this.connection.sendMessage(((JsonSignalHeadHttpService)this.service).doPost(type, name, data, request), request.id);
        }
        if (!this.beanListeners.containsKey(name) && (signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name)) != null) {
            SignalHeadListener listener = new SignalHeadListener(signalHead);
            signalHead.addPropertyChangeListener(listener);
            this.beanListeners.put(name, listener);
        }
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        this.connection.sendMessage(((JsonSignalHeadHttpService)this.service).doGetList(type, data, request), request.id);
        log.debug("adding SignalHeadsListener");
        if (this.managerListener == null) {
            this.managerListener = new SignalHeadsListener();
            InstanceManager.getDefault(SignalHeadManager.class).addPropertyChangeListener(this.managerListener);
        }
    }

    @Override
    public void onClose() {
        this.beanListeners.values().stream().forEach(listener -> listener.signalHead.removePropertyChangeListener((PropertyChangeListener)listener));
        this.beanListeners.clear();
        InstanceManager.getDefault(SignalHeadManager.class).removePropertyChangeListener(this.managerListener);
        this.managerListener = null;
    }

    private class SignalHeadListener
    implements PropertyChangeListener {
        protected final SignalHead signalHead;

        public SignalHeadListener(SignalHead signalHead) {
            this.signalHead = signalHead;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            try {
                try {
                    JsonSignalHeadSocketService.this.connection.sendMessage(((JsonSignalHeadHttpService)JsonSignalHeadSocketService.this.service).doGet("signalHead", this.signalHead.getSystemName(), (JsonNode)JsonSignalHeadSocketService.this.connection.getObjectMapper().createObjectNode(), new JsonRequest(JsonSignalHeadSocketService.this.getLocale(), JsonSignalHeadSocketService.this.getVersion(), "get", 0)), 0);
                }
                catch (JsonException ex) {
                    JsonSignalHeadSocketService.this.connection.sendMessage(ex.getJsonMessage(), 0);
                }
            }
            catch (IOException iOException) {
                this.signalHead.removePropertyChangeListener(this);
                JsonSignalHeadSocketService.this.beanListeners.remove(this.signalHead.getSystemName());
            }
        }
    }

    private class SignalHeadsListener
    implements PropertyChangeListener {
        private SignalHeadsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            log.debug("in SignalHeadsListener for '{}' ('{}' => '{}')", new Object[]{evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
            try {
                try {
                    JsonSignalHeadSocketService.this.connection.sendMessage(((JsonSignalHeadHttpService)JsonSignalHeadSocketService.this.service).doGetList("signalHeads", (JsonNode)((JsonSignalHeadHttpService)JsonSignalHeadSocketService.this.service).getObjectMapper().createObjectNode(), new JsonRequest(JsonSignalHeadSocketService.this.getLocale(), JsonSignalHeadSocketService.this.getVersion(), "get", 0)), 0);
                    if (evt.getPropertyName().equals("length")) {
                        this.removeListenersFromRemovedBeans();
                    }
                }
                catch (JsonException ex) {
                    log.warn("json error sending SignalHeads: {}", (Object)ex.getJsonMessage());
                    JsonSignalHeadSocketService.this.connection.sendMessage(ex.getJsonMessage(), 0);
                }
            }
            catch (IOException iOException) {}
        }

        private void removeListenersFromRemovedBeans() {
            SignalHeadManager manager = InstanceManager.getDefault(SignalHeadManager.class);
            for (String name : new HashSet(JsonSignalHeadSocketService.this.beanListeners.keySet())) {
                if (manager.getBySystemName(name) != null) continue;
                JsonSignalHeadSocketService.this.beanListeners.remove(name);
            }
        }
    }
}

