/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.roster;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.roster.Bundle;

public class JsonRosterHttpService
extends JsonHttpService {
    public JsonRosterHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public JsonNode doGet(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        switch (type) {
            case "roster": {
                ObjectNode node = this.mapper.createObjectNode();
                if (!name.isEmpty()) {
                    node.put("group", name);
                }
                return this.getRoster(request.locale, (JsonNode)node, request.id);
            }
            case "rosterEntry": {
                return this.getRosterEntry(request.locale, name, request.id);
            }
            case "rosterGroup": {
                return this.getRosterGroup(request.locale, name, request.id);
            }
            case "rosterGroups": {
                return this.getRosterGroups(request);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    public JsonNode doPost(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        switch (type) {
            case "rosterEntry": {
                return this.postRosterEntry(request.locale, name, data, request.id);
            }
            default: {
                throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
            }
            case "rosterGroup": 
            case "roster": 
            case "rosterGroups": 
        }
        throw new JsonException(405, Bundle.getMessage(request.locale, "PostNotAllowed", type), request.id);
    }

    @Override
    public JsonNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        switch (type) {
            case "rosterEntry": 
            case "roster": {
                return this.getRoster(request.locale, (JsonNode)this.mapper.createObjectNode(), request.id);
            }
            case "rosterGroup": 
            case "rosterGroups": {
                return this.getRosterGroups(request);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    public JsonNode getRoster(@Nonnull Locale locale, @Nonnull JsonNode data, int id) throws JsonException {
        String group;
        String string = group = !data.path("group").isMissingNode() ? data.path("group").asText() : null;
        if (Roster.ALLENTRIES.equals(group) || Roster.allEntries(locale).equals(group)) {
            group = null;
        }
        String roadName = !data.path("road").isMissingNode() ? data.path("road").asText() : null;
        String roadNumber = !data.path("number").isMissingNode() ? data.path("number").asText() : null;
        String dccAddress = !data.path("address").isMissingNode() ? data.path("address").asText() : null;
        String mfg = !data.path("mfg").isMissingNode() ? data.path("mfg").asText() : null;
        String decoderModel = !data.path("decoderModel").isMissingNode() ? data.path("decoderModel").asText() : null;
        String decoderFamily = !data.path("decoderFamily").isMissingNode() ? data.path("decoderFamily").asText() : null;
        String name = !data.path("name").isMissingNode() ? data.path("name").asText() : null;
        ArrayNode array = this.mapper.createArrayNode();
        for (RosterEntry entry : Roster.getDefault().getEntriesMatchingCriteria(roadName, roadNumber, dccAddress, mfg, decoderModel, decoderFamily, name, group)) {
            array.add(this.getRosterEntry(locale, entry, id));
        }
        return this.message(array, id);
    }

    public JsonNode getRosterEntry(Locale locale, String name, int id) throws JsonException {
        try {
            return this.getRosterEntry(locale, Roster.getDefault().getEntryForId(name), id);
        }
        catch (NullPointerException nullPointerException) {
            throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "rosterEntry", name), id);
        }
    }

    public JsonNode getRosterEntry(Locale locale, @Nonnull RosterEntry entry, int id) throws JsonException {
        String entryPath;
        try {
            entryPath = String.format("/%s/%s/", "roster", URLEncoder.encode(entry.getId(), StandardCharsets.UTF_8.toString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JsonException(500, Bundle.getMessage(locale, "ErrorUnencodeable", "rosterEntry", entry.getId(), "name"), id);
        }
        ObjectNode data = this.mapper.createObjectNode();
        data.put("name", entry.getId());
        data.put("address", entry.getDccAddress());
        data.put("isLongAddress", entry.isLongAddress());
        data.put("road", entry.getRoadName());
        data.put("number", entry.getRoadNumber());
        data.put("mfg", entry.getMfg());
        data.put("decoderModel", entry.getDecoderModel());
        data.put("decoderFamily", entry.getDecoderFamily());
        data.put("model", entry.getModel());
        data.put("comment", entry.getComment());
        data.put("maxSpeedPct", entry.getMaxSpeedPCT());
        data.put("image", entry.getImagePath() != null ? String.valueOf(entryPath) + "image" : null);
        data.put("icon", entry.getIconPath() != null ? String.valueOf(entryPath) + "icon" : null);
        data.put("shuntingFunction", entry.getShuntingFunction());
        data.put("owner", entry.getOwner());
        data.put("dateModified", entry.getDateModified() != null ? new StdDateFormat().format(entry.getDateModified()) : null);
        ArrayNode labels = data.putArray("functionKeys");
        int i = 0;
        while (i <= entry.getMAXFNNUM()) {
            ObjectNode label = this.mapper.createObjectNode();
            label.put("name", "F" + i);
            label.put("label", entry.getFunctionLabel(i));
            label.put("lockable", entry.getFunctionLockable(i));
            label.put("icon", entry.getFunctionImage(i) != null ? String.valueOf(entryPath) + "F" + i + "/" + "icon" : null);
            label.put("selectedIcon", entry.getFunctionSelectedImage(i) != null ? String.valueOf(entryPath) + "F" + i + "/" + "selectedIcon" : null);
            labels.add((JsonNode)label);
            ++i;
        }
        ArrayNode attributes = data.putArray("attributes");
        entry.getAttributes().stream().forEach(name -> {
            ObjectNode attribute = this.mapper.createObjectNode();
            attribute.put("name", name);
            attribute.put("value", entry.getAttribute((String)name));
            attributes.add((JsonNode)attribute);
        });
        ArrayNode rga = data.putArray("rosterGroups");
        entry.getGroups().stream().forEach(group -> {
            ArrayNode arrayNode2 = rga.add(group.getName());
        });
        return this.message("rosterEntry", (JsonNode)data, id);
    }

    public JsonNode getRosterGroups(JsonRequest request) throws JsonException {
        ArrayNode array = this.mapper.createArrayNode();
        array.add(this.getRosterGroup(request.locale, Roster.ALLENTRIES, request.id));
        for (String name : Roster.getDefault().getRosterGroupList()) {
            array.add(this.getRosterGroup(request.locale, name, request.id));
        }
        return this.message(array, request.id);
    }

    @Deprecated
    public JsonNode getRosterGroups(Locale locale, int id) throws JsonException {
        return this.getRosterGroups(new JsonRequest(locale, "v5", "get", id));
    }

    public JsonNode getRosterGroup(Locale locale, String name, int id) throws JsonException {
        if (name.equals(Roster.ALLENTRIES) || Roster.getDefault().getRosterGroupList().contains(name)) {
            int size = Roster.getDefault().getEntriesInGroup(name).size();
            ObjectNode data = this.mapper.createObjectNode();
            data.put("name", name.isEmpty() ? Roster.allEntries(locale) : name);
            data.put("length", size);
            return this.message("rosterGroup", (JsonNode)data, id);
        }
        throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "rosterGroup", name), id);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "rosterEntry": 
            case "roster": {
                return this.doSchema(type, server, "jmri/server/json/roster/" + type + "-server.json", "jmri/server/json/roster/" + type + "-client.json", request.id);
            }
            case "rosterGroup": 
            case "rosterGroups": {
                return this.doSchema(type, server, "jmri/server/json/roster/rosterGroup-server.json", "jmri/server/json/roster/rosterGroup-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    public JsonNode postRosterEntry(Locale locale, String name, JsonNode data, int id) throws JsonException {
        ArrayList toRemove;
        ArrayList toKeep;
        RosterEntry entry;
        try {
            entry = Roster.getDefault().getEntryForId(name);
        }
        catch (NullPointerException nullPointerException) {
            throw new JsonException(404, Bundle.getMessage(locale, "ErrorNotFound", "rosterEntry", name), id);
        }
        if (data.path("attributes").isArray()) {
            toKeep = new ArrayList();
            toRemove = new ArrayList();
            data.path("attributes").forEach(attribute -> {
                String key = attribute.path("name").asText();
                String value = attribute.path("value").isNull() ? null : attribute.path("value").asText();
                toKeep.add(key);
                entry.putAttribute(key, value);
            });
            entry.getAttributes().stream().filter(key -> !toKeep.contains(key) && !key.startsWith("RosterGroup:")).forEachOrdered(toRemove::add);
            toRemove.forEach(entry::deleteAttribute);
        }
        if (data.path("rosterGroups").isArray()) {
            toKeep = new ArrayList();
            toRemove = new ArrayList();
            data.path("rosterGroups").forEach(attribute -> {
                String key = attribute.asText();
                String value = attribute.path("value").isNull() ? null : attribute.path("value").asText();
                toKeep.add(key);
                entry.putAttribute(key, value);
            });
            entry.getGroups().stream().filter(key -> !toKeep.contains("RosterGroup:" + key)).forEachOrdered(key -> {
                boolean bl = toRemove.add("RosterGroup:" + key);
            });
            toRemove.forEach(entry::deleteAttribute);
        }
        if (data.path("functionKeys").isArray()) {
            data.path("functionKeys").forEach(functionKey -> {
                int function = Integer.parseInt(functionKey.path("name").asText().substring("F".length() - 1));
                entry.setFunctionLabel(function, functionKey.path("label").isNull() ? null : functionKey.path("label").asText());
                entry.setFunctionLockable(function, functionKey.path("lockable").asBoolean());
            });
        }
        if (data.path("address").isTextual()) {
            entry.setDccAddress(data.path("address").asText());
        }
        if (data.path("road").isTextual()) {
            entry.setRoadName(data.path("road").asText());
        }
        if (data.path("number").isTextual()) {
            entry.setRoadNumber(data.path("number").asText());
        }
        if (data.path("mfg").isTextual()) {
            entry.setMfg(data.path("mfg").asText());
        }
        if (data.path("model").isTextual()) {
            entry.setModel(data.path("model").asText());
        }
        if (!data.path("comment").isMissingNode()) {
            entry.setComment(data.path("comment").isTextual() ? data.path("comment").asText() : null);
        }
        if (data.path("maxSpeedPct").isInt()) {
            entry.setMaxSpeedPCT(data.path("maxSpeedPct").asInt());
        }
        if (!data.path("shuntingFunction").isMissingNode()) {
            entry.setShuntingFunction(data.path("shuntingFunction").isTextual() ? data.path("shuntingFunction").asText() : null);
        }
        if (!data.path("owner").isMissingNode()) {
            entry.setOwner(data.path("owner").isTextual() ? data.path("owner").asText() : null);
        }
        entry.updateFile();
        return this.getRosterEntry(locale, entry, id);
    }
}

