/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.reporter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.InstanceManager;
import jmri.Reportable;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.reporter.Bundle;

public class JsonReporterHttpService
extends JsonNamedBeanHttpService<Reporter> {
    public JsonReporterHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ObjectNode doPost(Reporter reporter, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        if (data.path("userName").isTextual()) {
            reporter.setUserName(data.path("userName").asText());
        }
        if (data.path("comment").isTextual()) {
            reporter.setComment(data.path("comment").asText());
        }
        if (!data.path("report").isMissingNode()) {
            if (data.path("report").isNull()) {
                reporter.setReport(null);
            } else {
                reporter.setReport(data.path("report").asText());
            }
        }
        return this.doGet(reporter, name, type, request);
    }

    @Override
    public ObjectNode doGet(Reporter reporter, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = this.getNamedBean(reporter, name, this.getType(), request);
        ObjectNode data = root.with("data");
        data.put("state", reporter.getState());
        Object cr = reporter.getCurrentReport();
        if (cr != null) {
            String report = cr instanceof Reportable ? ((Reportable)cr).toReportString() : cr.toString();
            data.put("report", report);
            data.put("value", report.isEmpty() ? Bundle.getMessage(request.locale, "Blank") : report);
        } else {
            data.putNull("report");
            data.put("value", Bundle.getMessage(request.locale, "NoReport"));
        }
        Object lr = reporter.getLastReport();
        if (lr != null) {
            String report = lr instanceof Reportable ? ((Reportable)lr).toReportString() : lr.toString();
            data.put("lastReport", report);
        } else {
            data.putNull("lastReport");
        }
        return root;
    }

    @Override
    protected void doDelete(Reporter reporter, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        super.deleteBean(reporter, name, type, data, request);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "reporter": 
            case "reporters": {
                return this.doSchema(type, server, "jmri/server/json/reporter/reporter-server.json", "jmri/server/json/reporter/reporter-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    protected ReporterManager getManager() {
        return InstanceManager.getDefault(ReporterManager.class);
    }

    @Override
    protected String getType() {
        return "reporter";
    }
}

