/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.power;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.power.JsonPowerHttpService;

public class JsonPowerSocketService
extends JsonSocketService<JsonPowerHttpService>
implements PropertyChangeListener {
    private boolean listening = false;

    public JsonPowerSocketService(JsonConnection connection) {
        this(connection, new JsonPowerHttpService(connection.getObjectMapper()));
    }

    protected JsonPowerSocketService(JsonConnection connection, JsonPowerHttpService service) {
        super(connection, service);
    }

    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        this.addListeners();
        this.connection.sendMessage(((JsonPowerHttpService)this.service).doPost(type, data.path("name").asText(), data, request), request.id);
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws JsonException, IOException {
        this.addListeners();
        this.connection.sendMessage(((JsonPowerHttpService)this.service).doGetList(type, data, request), request.id);
    }

    private void addListeners() {
        if (!this.listening) {
            InstanceManager.getList(PowerManager.class).forEach(manager -> manager.addPropertyChangeListener(this));
            this.listening = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            try {
                String name = ((PowerManager)evt.getSource()).getUserName();
                this.connection.sendMessage(((JsonPowerHttpService)this.service).doGet("power", name, (JsonNode)this.connection.getObjectMapper().createObjectNode(), new JsonRequest(this.connection.getLocale(), this.connection.getVersion(), "get", 0)), 0);
            }
            catch (JsonException ex) {
                this.connection.sendMessage(ex.getJsonMessage(), 0);
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public void onClose() {
        InstanceManager.getList(PowerManager.class).forEach(manager -> manager.removePropertyChangeListener(this));
    }
}

