/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.power;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.CheckForNull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.power.Bundle;

public class JsonPowerHttpService
extends JsonHttpService {
    public JsonPowerHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public JsonNode doGet(String type, @CheckForNull String name, JsonNode parameters, JsonRequest request) throws JsonException {
        ObjectNode data = this.mapper.createObjectNode();
        PowerManager manager = InstanceManager.getNullableDefault(PowerManager.class);
        if (name != null && !name.isEmpty()) {
            for (PowerManager pm : InstanceManager.getList(PowerManager.class)) {
                if (!pm.getUserName().equals(name)) continue;
                manager = pm;
            }
        }
        if (manager != null) {
            data.put("name", manager.getUserName());
            switch (manager.getPower()) {
                case 4: {
                    data.put("state", 4);
                    break;
                }
                case 2: {
                    data.put("state", 2);
                    break;
                }
                default: {
                    data.put("state", 0);
                }
            }
            data.put("default", false);
            if (manager.equals(InstanceManager.getDefault(PowerManager.class))) {
                data.put("default", true);
            }
        } else {
            data.put("state", 0);
            data.put("name", "");
            data.put("default", false);
        }
        return this.message("power", (JsonNode)data, request.id);
    }

    @Override
    public JsonNode doPost(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        block9: {
            int state = data.path("state").asInt(0);
            if (state != 0) {
                try {
                    PowerManager manager = InstanceManager.getNullableDefault(PowerManager.class);
                    if (!name.isEmpty()) {
                        for (PowerManager pm : InstanceManager.getList(PowerManager.class)) {
                            if (!pm.getUserName().equals(name)) continue;
                            manager = pm;
                        }
                    }
                    if (manager == null) break block9;
                    switch (state) {
                        case 4: {
                            manager.setPower(4);
                            break;
                        }
                        case 2: {
                            manager.setPower(2);
                            break;
                        }
                        default: {
                            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorUnknownState", "power", state), request.id);
                        }
                    }
                }
                catch (JmriException ex) {
                    throw new JsonException(500, ex, request.id);
                }
            }
        }
        return this.doGet(type, name, data, request);
    }

    @Override
    public JsonNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        ArrayNode array = this.mapper.createArrayNode();
        for (PowerManager manager : InstanceManager.getList(PowerManager.class)) {
            array.add(this.doGet(type, manager.getUserName(), data, request));
        }
        return this.message(array, request.id);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        if ("power".equals(type)) {
            return this.doSchema(type, server, "jmri/server/json/power/power-server.json", "jmri/server/json/power/power-client.json", request.id);
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }
}

