/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.operations;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.beans.Identifiable;
import jmri.beans.PropertyChangeProvider;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.operations.JsonOperationsHttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonOperationsSocketService
extends JsonSocketService<JsonOperationsHttpService> {
    private final HashMap<String, BeanListener<Car>> carListeners = new HashMap();
    private final HashMap<String, BeanListener<Engine>> engineListeners = new HashMap();
    private final HashMap<String, BeanListener<Location>> locationListeners = new HashMap();
    private final HashMap<String, BeanListener<Train>> trainListeners = new HashMap();
    private final CarsListener carsListener = new CarsListener();
    private final EnginesListener enginesListener = new EnginesListener();
    private final LocationsListener locationsListener = new LocationsListener();
    private final TrainsListener trainsListener = new TrainsListener();
    private static final Logger log = LoggerFactory.getLogger(JsonOperationsSocketService.class);

    public JsonOperationsSocketService(JsonConnection connection) {
        this(connection, new JsonOperationsHttpService(connection.getObjectMapper()));
    }

    protected JsonOperationsSocketService(JsonConnection connection, JsonOperationsHttpService service) {
        super(connection, service);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl72 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl72 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        this.connection.sendMessage(((JsonOperationsHttpService)this.service).doGetList(type, data, request), request.id);
        switch (type) {
            case "car": 
            case "cars": {
                log.debug("adding CarsListener");
                InstanceManager.getDefault(CarManager.class).addPropertyChangeListener(this.carsListener);
                break;
            }
            case "engines": 
            case "engine": {
                log.debug("adding EnginesListener");
                InstanceManager.getDefault(EngineManager.class).addPropertyChangeListener(this.enginesListener);
                break;
            }
            case "locations": 
            case "location": {
                log.debug("adding LocationsListener");
                InstanceManager.getDefault(LocationManager.class).addPropertyChangeListener(this.locationsListener);
                break;
            }
            case "trains": 
            case "train": {
                log.debug("adding TrainsListener");
                InstanceManager.getDefault(TrainManager.class).addPropertyChangeListener(this.trainsListener);
                break;
            }
        }
    }

    @Override
    public void onClose() {
        this.carListeners.values().forEach(listener -> ((Car)listener.bean).removePropertyChangeListener((PropertyChangeListener)listener));
        this.carListeners.clear();
        this.engineListeners.values().forEach(listener -> ((Engine)listener.bean).removePropertyChangeListener((PropertyChangeListener)listener));
        this.engineListeners.clear();
        this.locationListeners.values().forEach(listener -> ((Location)listener.bean).removePropertyChangeListener((PropertyChangeListener)listener));
        this.locationListeners.clear();
        this.trainListeners.values().forEach(listener -> ((Train)listener.bean).removePropertyChangeListener((PropertyChangeListener)listener));
        this.trainListeners.clear();
        InstanceManager.getDefault(CarManager.class).removePropertyChangeListener(this.carsListener);
        InstanceManager.getDefault(EngineManager.class).removePropertyChangeListener(this.enginesListener);
        InstanceManager.getDefault(LocationManager.class).removePropertyChangeListener(this.locationsListener);
        InstanceManager.getDefault(TrainManager.class).removePropertyChangeListener(this.trainsListener);
    }

    private /* synthetic */ BeanListener lambda$0(String id) {
        CarListener l = new CarListener(id);
        ((Car)InstanceManager.getDefault(CarManager.class).getById(id)).addPropertyChangeListener(l);
        return l;
    }

    private /* synthetic */ BeanListener lambda$1(String id) {
        EngineListener l = new EngineListener(id);
        ((Engine)InstanceManager.getDefault(EngineManager.class).getById(id)).addPropertyChangeListener(l);
        return l;
    }

    private /* synthetic */ BeanListener lambda$2(String id) {
        LocationListener l = new LocationListener(id);
        InstanceManager.getDefault(LocationManager.class).getLocationById(id).addPropertyChangeListener(l);
        return l;
    }

    private /* synthetic */ BeanListener lambda$3(String id) {
        TrainListener l = new TrainListener(id);
        InstanceManager.getDefault(TrainManager.class).getTrainById(id).addPropertyChangeListener(l);
        return l;
    }

    protected static abstract class BeanListener<B extends Identifiable & PropertyChangeProvider>
    implements PropertyChangeListener {
        protected final B bean;
        final /* synthetic */ JsonOperationsSocketService this$0;

        protected BeanListener(B bean) {
            this.this$0 = var1_1;
            this.bean = bean;
        }

        protected void propertyChange(String type, HashMap<String, BeanListener<B>> map) {
            try {
                this.sendSingleChange(type);
            }
            catch (IOException iOException) {
                ((PropertyChangeProvider)this.bean).removePropertyChangeListener(this);
                map.remove(this.bean.getId());
            }
        }

        private void sendSingleChange(String type) throws IOException {
            try {
                this.this$0.connection.sendMessage(((JsonOperationsHttpService)this.this$0.service).doGet(type, this.bean.getId(), (JsonNode)this.this$0.connection.getObjectMapper().createObjectNode(), new JsonRequest(this.this$0.getLocale(), this.this$0.getVersion(), "get", 0)), 0);
            }
            catch (JsonException ex) {
                log.warn("json error sending {}: {}", (Object)type, (Object)ex.getJsonMessage());
                this.this$0.connection.sendMessage(ex.getJsonMessage(), 0);
            }
        }
    }

    private class CarListener
    extends BeanListener<Car> {
        protected CarListener(String id) {
            super(JsonOperationsSocketService.this, (Identifiable)((Car)InstanceManager.getDefault(CarManager.class).getById(id)));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("car", JsonOperationsSocketService.this.carListeners);
        }
    }

    private class CarsListener
    extends ManagerListener<CarManager> {
        protected CarsListener() {
            super(JsonOperationsSocketService.this, (PropertyChangeProvider)InstanceManager.getDefault(CarManager.class));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("car");
        }
    }

    private class EngineListener
    extends BeanListener<Engine> {
        protected EngineListener(String id) {
            super(JsonOperationsSocketService.this, (Identifiable)((Engine)InstanceManager.getDefault(EngineManager.class).getById(id)));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("engine", JsonOperationsSocketService.this.engineListeners);
        }
    }

    private class EnginesListener
    extends ManagerListener<EngineManager> {
        protected EnginesListener() {
            super(JsonOperationsSocketService.this, (PropertyChangeProvider)InstanceManager.getDefault(EngineManager.class));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("engine");
        }
    }

    private class LocationListener
    extends BeanListener<Location> {
        protected LocationListener(String id) {
            super(JsonOperationsSocketService.this, (Identifiable)InstanceManager.getDefault(LocationManager.class).getLocationById(id));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("location", JsonOperationsSocketService.this.locationListeners);
        }
    }

    private class LocationsListener
    extends ManagerListener<LocationManager> {
        protected LocationsListener() {
            super(JsonOperationsSocketService.this, (PropertyChangeProvider)InstanceManager.getDefault(LocationManager.class));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("location");
        }
    }

    protected static abstract class ManagerListener<M extends PropertyChangeProvider>
    implements PropertyChangeListener {
        protected final M manager;
        final /* synthetic */ JsonOperationsSocketService this$0;

        protected ManagerListener(M mgr) {
            this.this$0 = var1_1;
            Objects.requireNonNull(mgr);
            this.manager = mgr;
        }

        protected void propertyChange(String type) {
            try {
                this.sendListChange(type);
            }
            catch (IOException iOException) {
                this.manager.removePropertyChangeListener(this);
            }
        }

        private void sendListChange(String type) throws IOException {
            try {
                this.this$0.connection.sendMessage(((JsonOperationsHttpService)this.this$0.service).doGetList(type, (JsonNode)((JsonOperationsHttpService)this.this$0.service).getObjectMapper().createObjectNode(), new JsonRequest(this.this$0.getLocale(), this.this$0.getVersion(), "get", 0)), 0);
            }
            catch (JsonException ex) {
                log.warn("json error sending {}: {}", (Object)type, (Object)ex.getJsonMessage());
                this.this$0.connection.sendMessage(ex.getJsonMessage(), 0);
            }
        }
    }

    private class TrainListener
    extends BeanListener<Train> {
        protected TrainListener(String id) {
            super(JsonOperationsSocketService.this, (Identifiable)InstanceManager.getDefault(TrainManager.class).getTrainById(id));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("train", JsonOperationsSocketService.this.trainListeners);
        }
    }

    private class TrainsListener
    extends ManagerListener<TrainManager> {
        protected TrainsListener() {
            super(JsonOperationsSocketService.this, (PropertyChangeProvider)InstanceManager.getDefault(TrainManager.class));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChange("train");
        }
    }
}

