/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.message.Bundle;

public class JsonMessageHttpService
extends JsonHttpService {
    public JsonMessageHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public JsonNode doGet(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "GetNotAllowed", type), request.id);
    }

    @Override
    public JsonNode doPost(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(405, Bundle.getMessage(request.locale, "PostNotAllowed", type), request.id);
    }

    public ArrayNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        throw new JsonException(400, Bundle.getMessage(request.locale, "UnlistableService", type), request.id);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "client": {
                return this.doSchema(type, server, "jmri/server/json/message/client-server.json", "jmri/server/json/message/client-client.json", request.id);
            }
            case "message": {
                if (server) {
                    try {
                        return this.doSchema(type, server, this.mapper.readTree(this.getClass().getClassLoader().getResource("jmri/server/json/message/message-server.json")), request.id);
                    }
                    catch (IOException ex) {
                        throw new JsonException(500, ex, request.id);
                    }
                }
                throw new JsonException(400, Bundle.getMessage(request.locale, "NotAClientType", type), request.id);
            }
            case "hello": {
                return this.doSchema(type, server, "jmri/server/json/util/hello-server.json", "jmri/server/json/util/hello-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }
}

