/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManagerAutoDefault;
import jmri.server.json.JsonConnection;
import jmri.server.json.message.JsonMessage;

public class JsonMessageClientManager
implements InstanceManagerAutoDefault {
    final ObjectMapper mapper = new ObjectMapper();
    HashMap<String, JsonConnection> clients = new HashMap();

    public void subscribe(@Nonnull String client, @Nonnull JsonConnection connection) {
        if (this.clients.containsKey(client) && !connection.equals(this.clients.get(client))) {
            throw new IllegalArgumentException("client in use with different connection");
        }
        this.clients.putIfAbsent(client, connection);
    }

    public void unsubscribe(@CheckForNull String client) {
        this.clients.remove(client);
    }

    public void unsubscribe(@CheckForNull JsonConnection connection) {
        ArrayList keys = new ArrayList();
        this.clients.entrySet().stream().filter(entry -> ((JsonConnection)entry.getValue()).equals(connection)).forEachOrdered(entry -> {
            boolean bl = keys.add((String)entry.getKey());
        });
        keys.forEach(this::unsubscribe);
    }

    public void send(@Nonnull JsonMessage message) {
        JsonNode node = this.getJsonMessage(message);
        if (message.getClient() == null) {
            new HashMap<String, JsonConnection>(this.clients).entrySet().forEach(client -> {
                try {
                    ((JsonConnection)client.getValue()).sendMessage(node, 0);
                }
                catch (IOException iOException) {
                    this.unsubscribe((String)client.getKey());
                }
            });
        } else {
            JsonConnection connection = this.clients.get(message.getClient());
            if (connection != null) {
                try {
                    connection.sendMessage(node, 0);
                }
                catch (IOException iOException) {
                    this.unsubscribe(message.getClient());
                }
            }
        }
    }

    private JsonNode getJsonMessage(JsonMessage message) {
        return message.toJSON(this.mapper);
    }

    @CheckForNull
    public synchronized String getClient(@Nonnull JsonConnection connection) {
        for (Map.Entry<String, JsonConnection> entry : this.clients.entrySet()) {
            if (!entry.getValue().equals(connection)) continue;
            return entry.getKey();
        }
        return null;
    }

    public synchronized Set<String> getClients(@Nonnull JsonConnection connection) {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, JsonConnection> entry : this.clients.entrySet()) {
            if (!entry.getValue().equals(connection)) continue;
            set.add(entry.getKey());
        }
        return set;
    }
}

