/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.server.json.JsonHttpService;
import jmri.server.json.message.JsonMessageClientManager;

public class JsonMessage {
    public static final String CLIENT = "client";
    public static final String MESSAGE = "message";
    public static final String CONTEXT = "context";
    public static final String INFO = "info";
    public static final String SUCCESS = "success";
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    private final String message;
    private final Locale locale;
    private final String client;
    private final JsonNode context;
    private final TYPE type;

    public JsonMessage(@Nonnull String message, @Nonnull Locale locale) {
        this(TYPE.INFO, message, null, null, locale);
    }

    public JsonMessage(TYPE type, @Nonnull String message, @Nonnull Locale locale) {
        this(type, message, null, null, locale);
    }

    public JsonMessage(TYPE type, @Nonnull String message, @CheckForNull String client, @Nonnull Locale locale) {
        this(type, message, client, null, locale);
    }

    public JsonMessage(TYPE type, @Nonnull String message, @CheckForNull String client, @CheckForNull JsonNode context, @Nonnull Locale locale) {
        this.type = type;
        this.message = message;
        this.locale = locale;
        this.client = client;
        this.context = context != null && context.isObject() ? context : null;
    }

    public void send() {
        InstanceManager.getDefault(JsonMessageClientManager.class).send(this);
    }

    public String getClient() {
        return this.client;
    }

    public JsonNode getContext() {
        return this.context;
    }

    public String getMessage() {
        return this.message;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getType() {
        switch (this.type) {
            case SUCCESS: {
                return SUCCESS;
            }
            case WARNING: {
                return WARNING;
            }
            case ERROR: {
                return ERROR;
            }
        }
        return INFO;
    }

    public JsonNode toJSON(ObjectMapper mapper) {
        ObjectNode data = mapper.createObjectNode();
        data.put(MESSAGE, this.getMessage());
        if (this.getContext() != null) {
            data.set(CONTEXT, this.getContext());
        } else {
            data.putNull(CONTEXT);
        }
        data.put("type", this.getType());
        data.put("locale", this.getLocale().toLanguageTag());
        return JsonHttpService.message(mapper, MESSAGE, (JsonNode)data, null, 0);
    }

    public static enum TYPE {
        INFO,
        SUCCESS,
        WARNING,
        ERROR;

    }
}

