/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.light;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.ProvidingManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.light.Bundle;

public class JsonLightHttpService
extends JsonNamedBeanHttpService<Light> {
    public JsonLightHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ObjectNode doGet(Light light, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = this.getNamedBean(light, name, this.getType(), request);
        ObjectNode data = root.with("data");
        if (light != null) {
            switch (light.getState()) {
                case 2: {
                    data.put("state", 2);
                    break;
                }
                case 4: {
                    data.put("state", 4);
                    break;
                }
                case 8: {
                    data.put("state", 8);
                    break;
                }
                default: {
                    data.put("state", 0);
                }
            }
        }
        return root;
    }

    @Override
    public ObjectNode doPost(Light light, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        int state = data.path("state").asInt(0);
        switch (state) {
            case 2: {
                light.setState(2);
                break;
            }
            case 4: {
                light.setState(4);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorUnknownState", "light", state), request.id);
            }
        }
        return this.doGet(light, name, type, request);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "lights": 
            case "light": {
                return this.doSchema(type, server, "jmri/server/json/light/light-server.json", "jmri/server/json/light/light-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    protected String getType() {
        return "light";
    }

    @Override
    protected ProvidingManager<Light> getManager() {
        return InstanceManager.getDefault(LightManager.class);
    }
}

