/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.layoutblock;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNonProvidedNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.layoutblock.Bundle;
import jmri.util.ColorUtil;

public class JsonLayoutBlockHttpService
extends JsonNonProvidedNamedBeanHttpService<LayoutBlock> {
    public JsonLayoutBlockHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="check here for null is complexity for a situation that should not be possible")
    public JsonNode doGet(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        return this.doGet((LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getBySystemName(name), name, type, request);
    }

    @Override
    protected ObjectNode doGet(LayoutBlock layoutBlock, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = super.getNamedBean(layoutBlock, name, type, request);
        ObjectNode data = root.with("data");
        data.put("state", layoutBlock.getState());
        data.put("useExtraColor", layoutBlock.getUseExtraColor());
        data.put("blockColor", ColorUtil.colorToColorName(layoutBlock.getBlockColor()));
        data.put("trackColor", ColorUtil.colorToColorName(layoutBlock.getBlockTrackColor()));
        data.put("occupiedColor", ColorUtil.colorToColorName(layoutBlock.getBlockOccupiedColor()));
        data.put("extraColor", ColorUtil.colorToColorName(layoutBlock.getBlockExtraColor()));
        if (layoutBlock.getOccupancySensor() != null) {
            data.put("occupancySensor", layoutBlock.getOccupancySensor().getSystemName());
        } else {
            data.putNull("occupancySensor");
        }
        if (layoutBlock.getMemory() != null) {
            data.put("memory", layoutBlock.getMemory().getSystemName());
        } else {
            data.putNull("memory");
        }
        if (layoutBlock.getBlock() != null) {
            data.put("block", layoutBlock.getBlock().getSystemName());
        } else {
            data.putNull("block");
        }
        data.put("occupiedSense", layoutBlock.getOccupiedSense());
        return root;
    }

    @Override
    public JsonNode doPost(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        return this.doPost((LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getBySystemName(name), data, name, type, request);
    }

    public JsonNode doPost(LayoutBlock layoutBlock, JsonNode data, String name, String type, JsonRequest request) throws JsonException {
        this.postNamedBean(layoutBlock, data, name, type, request);
        this.setBlockTrackColor(layoutBlock, "trackColor", type, data, request);
        this.setBlockTrackColor(layoutBlock, "occupiedColor", type, data, request);
        this.setBlockTrackColor(layoutBlock, "extraColor", type, data, request);
        String string = "";
        if (!data.path("memory").isMissingNode()) {
            String string2 = string = !data.path("memory").isNull() ? data.path("memory").asText() : null;
            if (string != null) {
                Memory memory = InstanceManager.getDefault(MemoryManager.class).getBySystemName(string);
                if (memory == null) {
                    throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", "memory", string), request.id);
                }
                layoutBlock.setMemoryName(memory.getUserName());
            } else {
                layoutBlock.setMemoryName(null);
            }
        }
        if (!data.path("occupancySensor").isMissingNode()) {
            String string3 = string = !data.path("occupancySensor").isNull() ? data.path("occupancySensor").asText() : null;
            if (string != null) {
                Sensor sensor = InstanceManager.getDefault(SensorManager.class).getBySystemName(string);
                if (sensor == null) {
                    throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", "sensor", string), request.id);
                }
                layoutBlock.setOccupancySensorName(sensor.getUserName());
            } else {
                layoutBlock.setOccupancySensorName(null);
            }
        }
        layoutBlock.setUseExtraColor(data.path("useExtraColor").asBoolean(layoutBlock.getUseExtraColor()));
        return this.doGet(layoutBlock, name, type, request);
    }

    private void setBlockTrackColor(LayoutBlock layoutBlock, String key, String type, JsonNode data, JsonRequest request) throws JsonException {
        String value = "";
        try {
            Color color;
            value = data.path(key).asText();
            Color color2 = color = !data.path(key).isMissingNode() ? ColorUtil.stringToColor(value) : null;
            if (color != null) {
                layoutBlock.setBlockTrackColor(color);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorBadPropertyValue", value, key, type), request.id);
        }
    }

    @Override
    public JsonNode doPut(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        LayoutBlock layoutBlock = null;
        String systemName = name;
        if (systemName.isEmpty()) {
            systemName = null;
        }
        if (data.path("userName").isMissingNode() || data.path("userName").isNull()) {
            layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).createNewLayoutBlock();
        } else {
            String userName = data.path("userName").asText();
            if (!userName.isEmpty()) {
                layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).createNewLayoutBlock(systemName, userName);
            } else {
                throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorEmptyAttribute", "userName", type), request.id);
            }
        }
        if (layoutBlock == null) {
            throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorInternal", type), request.id);
        }
        layoutBlock.initializeLayoutBlock();
        layoutBlock.initializeLayoutBlockRouting();
        return this.doPost(layoutBlock, data, name, type, request);
    }

    @Override
    public void doDelete(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        LayoutBlock layoutBlock = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getBySystemName(name);
        if (layoutBlock == null) {
            throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", type, name), request.id);
        }
        ArrayList<String> listeners = layoutBlock.getListenerRefs();
        if (!listeners.isEmpty() && !this.acceptForceDeleteToken(type, name, data.path("forceDelete").asText())) {
            ArrayNode conflicts = this.mapper.createArrayNode();
            listeners.forEach(arg_0 -> ((ArrayNode)conflicts).add(arg_0));
            this.throwDeleteConflictException(type, name, conflicts, request);
        } else {
            InstanceManager.getDefault(LayoutBlockManager.class).deregister(layoutBlock);
        }
    }

    @Override
    public JsonNode doGetList(String type, JsonNode data, JsonRequest request) throws JsonException {
        return this.doGetList(InstanceManager.getDefault(LayoutBlockManager.class), "layoutBlock", data, request);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        switch (type) {
            case "layoutBlocks": 
            case "layoutBlock": {
                return this.doSchema(type, server, "jmri/server/json/layoutblock/layoutBlock-server.json", "jmri/server/json/layoutblock/layoutBlock-client.json", request.id);
            }
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    public LayoutBlock getNamedBean(String type, String name, JsonNode data, JsonRequest request) throws JsonException {
        try {
            if (!data.isEmpty() && !data.isNull()) {
                if ("put".equals(request.method)) {
                    this.doPut(type, name, data, request);
                } else if ("post".equals(request.method)) {
                    this.doPost(type, name, data, request);
                }
            }
            return (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getBySystemName(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonException(400, Bundle.getMessage(request.locale, "ErrorInvalidSystemName", name, type), request.id);
        }
    }
}

