/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.idtag;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.util.Date;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.ProvidingManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.server.json.JsonException;
import jmri.server.json.JsonNamedBeanHttpService;
import jmri.server.json.JsonRequest;
import jmri.server.json.idtag.Bundle;

public class JsonIdTagHttpService
extends JsonNamedBeanHttpService<IdTag> {
    public JsonIdTagHttpService(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ObjectNode doGet(IdTag idTag, String name, String type, JsonRequest request) throws JsonException {
        ObjectNode root = this.getNamedBean(idTag, name, this.getType(), request);
        ObjectNode data = root.with("data");
        if (idTag != null) {
            int state = idTag.getState();
            if (state == 1) {
                data.put("state", 0);
            } else {
                data.put("state", state);
            }
            Reporter reporter = idTag.getWhereLastSeen();
            data.put("reporter", reporter != null ? reporter.getSystemName() : null);
            Date date = idTag.getWhenLastSeen();
            data.put("time", date != null ? new StdDateFormat().format(date) : null);
        }
        return root;
    }

    @Override
    public ObjectNode doPost(IdTag idTag, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        JsonNode node = data.path("reporter");
        if (node.isNull()) {
            idTag.setWhereLastSeen(null);
        } else if (node.isTextual()) {
            Reporter reporter = InstanceManager.getDefault(ReporterManager.class).getBySystemName(node.asText());
            if (reporter != null) {
                idTag.setWhereLastSeen(reporter);
            } else {
                throw new JsonException(404, Bundle.getMessage(request.locale, "ErrorNotFound", "reporter", node.asText()), request.id);
            }
        }
        return this.doGet(idTag, name, type, request);
    }

    @Override
    public void doDelete(IdTag bean, String name, String type, JsonNode data, JsonRequest request) throws JsonException {
        super.deleteBean(bean, name, type, data, request);
    }

    @Override
    public JsonNode doSchema(String type, boolean server, JsonRequest request) throws JsonException {
        if ("idTag".equals(type)) {
            return this.doSchema(type, server, "jmri/server/json/idtag/idTag-server.json", "jmri/server/json/idtag/idTag-client.json", request.id);
        }
        throw new JsonException(500, Bundle.getMessage(request.locale, "ErrorUnknownType", type), request.id);
    }

    @Override
    protected String getType() {
        return "idTag";
    }

    @Override
    protected ProvidingManager<IdTag> getManager() {
        return InstanceManager.getDefault(IdTagManager.class);
    }
}

