/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json.consist;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashSet;
import jmri.ConsistListListener;
import jmri.ConsistListener;
import jmri.DccLocoAddress;
import jmri.JmriException;
import jmri.LocoAddress;
import jmri.jmrit.consisttool.ConsistFile;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonRequest;
import jmri.server.json.JsonSocketService;
import jmri.server.json.consist.JsonConsistHttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConsistSocketService
extends JsonSocketService<JsonConsistHttpService> {
    private final HashSet<LocoAddress> consists = new HashSet();
    private final JsonConsistListener consistListener = new JsonConsistListener();
    private final JsonConsistListListener consistListListener = new JsonConsistListListener();
    private static final Logger log = LoggerFactory.getLogger(JsonConsistSocketService.class);

    public JsonConsistSocketService(JsonConnection connection) {
        super(connection, new JsonConsistHttpService(connection.getObjectMapper()));
        ((JsonConsistHttpService)this.service).manager.addConsistListListener(this.consistListListener);
    }

    @Override
    public void onMessage(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        if ("consists".equals(type)) {
            this.connection.sendMessage(((JsonConsistHttpService)this.service).doGetList(type, data, request), request.id);
        } else {
            DccLocoAddress address = new DccLocoAddress(data.path("address").asInt(), data.path("isLongAddress").asBoolean());
            String name = String.valueOf(address.getNumber()) + (address.isLongAddress() ? "L" : "");
            if (request.method.equals("put")) {
                this.connection.sendMessage(((JsonConsistHttpService)this.service).doPut(type, name, data, request), request.id);
            } else {
                this.connection.sendMessage(((JsonConsistHttpService)this.service).doPost(type, name, data, request), request.id);
            }
            if (!this.consists.contains(address)) {
                ((JsonConsistHttpService)this.service).manager.getConsist(address).addConsistListener(this.consistListener);
                this.consists.add(address);
            }
        }
    }

    @Override
    public void onList(String type, JsonNode data, JsonRequest request) throws IOException, JmriException, JsonException {
        this.connection.sendMessage(((JsonConsistHttpService)this.service).doGetList(type, data, request), request.id);
    }

    @Override
    public void onClose() {
        this.consists.stream().forEach(address -> ((JsonConsistHttpService)this.service).manager.getConsist((LocoAddress)address).removeConsistListener(this.consistListener));
        this.consists.clear();
        ((JsonConsistHttpService)this.service).manager.removeConsistListListener(this.consistListListener);
    }

    private class JsonConsistListListener
    implements ConsistListListener {
        private JsonConsistListListener() {
        }

        @Override
        public void notifyConsistListChanged() {
            try {
                try {
                    JsonConsistSocketService.this.connection.sendMessage(((JsonConsistHttpService)JsonConsistSocketService.this.service).doGetList("consists", (JsonNode)((JsonConsistHttpService)JsonConsistSocketService.this.service).getObjectMapper().createObjectNode(), new JsonRequest(JsonConsistSocketService.this.getLocale(), JsonConsistSocketService.this.getVersion(), "get", 0)), 0);
                }
                catch (JsonException ex) {
                    JsonConsistSocketService.this.connection.sendMessage(ex.getJsonMessage(), 0);
                }
            }
            catch (IOException iOException) {
                ((JsonConsistHttpService)((JsonConsistSocketService)JsonConsistSocketService.this).service).manager.removeConsistListListener(this);
            }
            try {
                new ConsistFile().writeFile(((JsonConsistHttpService)((JsonConsistSocketService)JsonConsistSocketService.this).service).manager.getConsistList());
            }
            catch (IOException ex) {
                log.error("Unable to write consist file \"{}\"", (Object)ConsistFile.defaultConsistFilename(), (Object)ex);
            }
        }
    }

    private class JsonConsistListener
    implements ConsistListener {
        private JsonConsistListener() {
        }

        @Override
        public void consistReply(LocoAddress locoaddress, int status) {
            try {
                try {
                    JsonConsistSocketService.this.connection.sendMessage(((JsonConsistHttpService)JsonConsistSocketService.this.service).getConsist(locoaddress, new JsonRequest(JsonConsistSocketService.this.getLocale(), "v5", "get", 0)), 0);
                }
                catch (JsonException ex) {
                    JsonConsistSocketService.this.connection.sendMessage(ex.getJsonMessage(), 0);
                }
            }
            catch (IOException iOException) {
                ((JsonConsistHttpService)((JsonConsistSocketService)JsonConsistSocketService.this).service).manager.getConsist(locoaddress).removeConsistListener(this);
                JsonConsistSocketService.this.consists.remove(locoaddress);
            }
            try {
                new ConsistFile().writeFile(((JsonConsistHttpService)((JsonConsistSocketService)JsonConsistSocketService.this).service).manager.getConsistList());
            }
            catch (IOException ex) {
                log.error("Unable to write consist file \"{}\"", (Object)ConsistFile.defaultConsistFilename(), (Object)ex);
            }
        }
    }
}

