/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonException;
import jmri.server.json.JsonHttpService;
import jmri.server.json.JsonRequest;

public abstract class JsonSocketService<H extends JsonHttpService> {
    protected final JsonConnection connection;
    protected final H service;

    protected JsonSocketService(@Nonnull JsonConnection connection, @Nonnull H service) {
        this.connection = connection;
        this.service = service;
    }

    public abstract void onMessage(@Nonnull String var1, @Nonnull JsonNode var2, @Nonnull JsonRequest var3) throws IOException, JmriException, JsonException;

    @Deprecated
    public void onMessage(@Nonnull String type, @Nonnull JsonNode data, @Nonnull String method, @Nonnull Locale locale, int id) throws IOException, JmriException, JsonException {
        this.onMessage(type, data, new JsonRequest(locale, "v5", method, id));
    }

    public abstract void onList(@Nonnull String var1, @Nonnull JsonNode var2, @Nonnull JsonRequest var3) throws IOException, JmriException, JsonException;

    @Deprecated
    public void onList(@Nonnull String type, @Nonnull JsonNode data, @Nonnull Locale locale, int id) throws IOException, JmriException, JsonException {
        this.onList(type, data, new JsonRequest(locale, "v5", "get", id));
    }

    public abstract void onClose();

    @Nonnull
    public final JsonConnection getConnection() {
        return this.connection;
    }

    @Nonnull
    public final H getHttpService() {
        return this.service;
    }

    @Nonnull
    protected final Locale getLocale() {
        return this.connection.getLocale();
    }

    @Deprecated
    protected final void setLocale(@Nonnull Locale locale) {
        this.connection.setLocale(locale);
    }

    protected final String getVersion() {
        return this.connection.getVersion();
    }
}

