/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import jmri.InstanceManagerAutoDefault;
import jmri.beans.Bean;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;
import jmri.util.FileUtil;
import jmri.util.prefs.JmriPreferencesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonServerPreferences
extends Bean
implements InstanceManagerAutoDefault {
    public static final int DEFAULT_PORT = 2056;
    static final String XML_PREFS_ELEMENT = "JSONServerPreferences";
    static final String HEARTBEAT_INTERVAL = "heartbeatInterval";
    static final String PORT = "port";
    static final String VALIDATE_CLIENT = "validateClientMessages";
    static final String VALIDATE_SERVER = "validateServerMessages";
    private int heartbeatInterval = 15000;
    private int portNumber = 2056;
    private boolean validateClientMessages = false;
    private boolean validateServerMessages = false;
    private int asLoadedHeartbeatInterval = 15000;
    private int asLoadedPort = 2056;
    private static final Logger log = LoggerFactory.getLogger(JsonServerPreferences.class);

    public JsonServerPreferences(String fileName) {
        boolean migrate = false;
        Profile activeProfile = ProfileManager.getDefault().getActiveProfile();
        Preferences sharedPreferences = ProfileUtils.getPreferences(activeProfile, this.getClass(), true);
        boolean bl = migrate = sharedPreferences.get(PORT, null) == null;
        if (migrate) {
            Preferences oldPreferences = JmriPreferencesProvider.getPreferences(activeProfile, "jmri.jmris.json", true);
            this.readPreferences(oldPreferences);
        }
        this.readPreferences(sharedPreferences);
        if (migrate) {
            try {
                log.info("Migrating from old JsonServer preferences in {} to new format in {}.", (Object)fileName, (Object)FileUtil.getAbsoluteFilename("profile:profile"));
                sharedPreferences.sync();
            }
            catch (BackingStoreException ex) {
                log.error("Unable to write JsonServer preferences.", (Throwable)ex);
            }
        }
    }

    public JsonServerPreferences() {
        Preferences sharedPreferences = ProfileUtils.getPreferences(ProfileManager.getDefault().getActiveProfile(), this.getClass(), true);
        this.readPreferences(sharedPreferences);
    }

    private void readPreferences(Preferences sharedPreferences) {
        this.setHeartbeatInterval(sharedPreferences.getInt(HEARTBEAT_INTERVAL, this.getHeartbeatInterval()));
        this.setPort(sharedPreferences.getInt(PORT, this.getPort()));
        this.setValidateClientMessages(sharedPreferences.getBoolean(VALIDATE_CLIENT, this.getValidateClientMessages()));
        this.setValidateServerMessages(sharedPreferences.getBoolean(VALIDATE_SERVER, this.getValidateServerMessages()));
        this.asLoadedHeartbeatInterval = this.getHeartbeatInterval();
        this.asLoadedPort = this.getPort();
    }

    public boolean compareValuesDifferent(JsonServerPreferences prefs) {
        if (this.getHeartbeatInterval() != prefs.getHeartbeatInterval()) {
            return true;
        }
        return this.getPort() != prefs.getPort();
    }

    public void apply(JsonServerPreferences prefs) {
        this.setHeartbeatInterval(prefs.getHeartbeatInterval());
        this.setPort(prefs.getPort());
    }

    public void save() {
        Preferences sharedPreferences = ProfileUtils.getPreferences(ProfileManager.getDefault().getActiveProfile(), this.getClass(), true);
        sharedPreferences.putInt(HEARTBEAT_INTERVAL, this.heartbeatInterval);
        sharedPreferences.putInt(PORT, this.portNumber);
        sharedPreferences.putBoolean(VALIDATE_CLIENT, this.validateClientMessages);
        sharedPreferences.putBoolean(VALIDATE_SERVER, this.validateServerMessages);
    }

    public boolean isDirty() {
        return this.getHeartbeatInterval() != this.asLoadedHeartbeatInterval || this.getPort() != this.asLoadedPort;
    }

    public boolean isRestartRequired() {
        return this.getHeartbeatInterval() != this.asLoadedHeartbeatInterval || this.getPort() != this.asLoadedPort;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(int value) {
        this.heartbeatInterval = value;
    }

    public int getPort() {
        return this.portNumber;
    }

    public void setPort(int value) {
        this.portNumber = value;
    }

    public boolean getValidateClientMessages() {
        return this.validateClientMessages;
    }

    public void setValidateClientMessages(boolean validate) {
        this.validateClientMessages = validate;
    }

    public boolean getValidateServerMessages() {
        return this.validateServerMessages;
    }

    public void setValidateServerMessages(boolean validate) {
        this.validateServerMessages = validate;
    }
}

