/*
 * Decompiled with CFR 0.152.
 */
package jmri.server.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.implementation.AbstractShutDownTask;
import jmri.jmris.JmriServer;
import jmri.server.json.JsonClientHandler;
import jmri.server.json.JsonConnection;
import jmri.server.json.JsonServerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonServer
extends JmriServer
implements InstanceManagerAutoDefault {
    private static final Logger log = LoggerFactory.getLogger(JsonServer.class);
    private ObjectMapper mapper = new ObjectMapper().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);

    public JsonServer() {
        this(InstanceManager.getDefault(JsonServerPreferences.class).getPort(), InstanceManager.getDefault(JsonServerPreferences.class).getHeartbeatInterval());
    }

    public JsonServer(int port, int timeout) {
        super(port, timeout);
        this.shutDownTask = new AbstractShutDownTask("Stop JSON Server"){

            @Override
            public void run() {
                try {
                    JsonServer.this.stop();
                }
                catch (Exception ex) {
                    log.warn("Exception shutting down JSON Server: {}", (Throwable)ex);
                }
            }
        };
    }

    @Override
    public void start() {
        log.info("Starting JSON Server on port {}", (Object)this.portNo);
        super.start();
    }

    @Override
    public void stop() {
        log.info("Stopping JSON Server.");
        super.stop();
    }

    @Override
    protected void advertise() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("json", "5.4.0");
        this.advertise("_jmri-json._tcp.local.", properties);
    }

    @Override
    public void handleClient(DataInputStream inStream, DataOutputStream outStream) throws IOException {
        ObjectReader reader = this.mapper.reader();
        JsonClientHandler handler = new JsonClientHandler(new JsonConnection(outStream));
        handler.onMessage("{\"type\":\"hello\"}");
        boolean handling = true;
        while (handling) {
            try {
                handler.onMessage(reader.readTree((InputStream)inStream));
            }
            catch (IOException e) {
                handler.onClose();
                throw e;
            }
            catch (NoSuchElementException noSuchElementException) {
                handling = false;
            }
        }
        handler.onClose();
    }

    @Override
    public void stopClient(DataInputStream inStream, DataOutputStream outStream) throws IOException {
        outStream.writeBytes(this.mapper.writeValueAsString((Object)this.mapper.createObjectNode().put("type", "goodbye")));
        try {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            log.debug("Wait to send clean shutdown message interrupted.");
            Thread.currentThread().interrupt();
        }
    }
}

